#declare R=2;

camera { location  <2*R, 2*R, -4*R> look_at <0, -2.5, 0> angle 40}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

// ----------------------------------------
                                
                                

#declare Fx = function {sin(u)}
#declare Fz = function {cos(u+v)}
#declare Fy = function {-abs(v)/2}
                        
#declare U1 = -pi;
#declare U2 =  pi;
#declare V1 =  -40;                       
#declare V2 =  40;

parametric {
  function {Fx(u,v,0)}
  function {Fy(u,v,0)}
  function {Fz(u,v,0)}
      <U1,V1>,<U2,V2>
  contained_by{box{<-R,-10,-R>,<R,R,R>}}
  precompute 18, x,y,z
  pigment {rgb 0.9}
  finish {phong 0.5 phong_size 10}
  no_shadow
}
      
//box {-R,R pigment {rgbt <1,0,0,0.95>}}
