#declare R=2;

camera { location  <4*R, 2*R, -4*R> look_at <0, 0.3, 0> angle 20}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

// ----------------------------------------
                                
                                
//Dini's surface
//Dini's surface of constant negative curvature. Looks like a flower


#declare A=1;
#declare B=0.2;

#declare Fx = function {A*cos(u)*sin(v)}
#declare Fy = function {A*sin(u)*sin(v)}
#declare Fz = function {A*(cos(v)+ln(tan(v/2))) + B*u}

parametric {
  function {Fx(u,v,0)}
  function {Fy(u,v,0)}
  function {Fz(u,v,0)}
      <-2*pi,0.001>,<4*pi,2.1>
  contained_by{box{<-R,-R,-R>,<R,R,R>}}
  precompute 18, x,y,z
  pigment {rgb 0.9}
  finish {phong 0.5 phong_size 10}
  no_shadow 
  rotate x*90
}
      
