
camera { location  <10, 10, -30> look_at <0, 0, 0> angle 7}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}


#declare Fx = function(u,v){ (1-u*u)*sin(v) }
#declare Fy = function(u,v){ (1-u*u)*sin(2*v) }
#declare Fz = function(u,v){ u }

#include "param.inc"

object {Parametric(Fx,Fy,Fz,<-1.0,0>,<1.0,2*pi>,50,50,"")
  pigment {uv_mapping checker rgb 0.95 rgb 0.85 scale 0.2}
  finish {phong 0.5 phong_size 10}
  no_shadow
}
