
camera { location  <0, 10, -30> look_at <0, 0, 0> angle 6}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}


#declare Fx = function(u,v){ cos(u)*sin(2*v) }
#declare Fy = function(u,v){ sin(v) }
#declare Fz = function(u,v){ sin(u)*sin(2*v) }

#include "param.inc"

object {Parametric(Fx,Fy,Fz,<0,-pi/2>,<2*pi,pi/2>,50,50,"")
  pigment {uv_mapping checker rgb 0.9 rgb 0.85 scale <0.6,0.2,1>}
  finish {phong 0.5 phong_size 10}
  no_shadow
}
