//Crescent

camera { location  <0, 0, -30> look_at <0, 0, 0> angle 15}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}


#declare A=1.6;         // values between 1.0 and 2.0 give crescent shapes

#declare Fx = function(u,v){ (2+sin(u)*sin(v))*sin(A*v) }
#declare Fy = function(u,v){ (2+sin(u)*sin(v))*cos(A*v) }
#declare Fz = function(u,v){ cos(u)*sin(v)}

#include "param.inc"


object {Parametric(Fx,Fy,Fz,<0,0>,<2*pi,pi>,30,60,"")
  pigment {uv_mapping checker rgb 0.95 rgb 0.85 scale <0.25,0.1>}
  finish {phong 0.5 phong_size 10}
}
