// Catenoid
//
// The surface of revolution created by a catenary curve is a minimal surface

camera { location  <0, 10, -30> look_at <0, 0, 0> angle 15}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

#declare a = 1;  

#declare Fx = function(u,v){ a*cos(u)*cosh(v/a) }
#declare Fy = function(u,v){ v }
#declare Fz = function(u,v){ a*sin(u)*cosh(v/a) }

#include "param.inc"

object {Parametric(Fx,Fy,Fz,<0,-2>,<2*pi,2>,50,50,"")
  pigment {uv_mapping checker rgb 0.9 rgb 0.85 scale 0.3}
  finish {phong 0.5 phong_size 10}
  no_shadow
}
