#include "math.inc"

//Value Being Solved for
#ifndef(isoThreshold) 				#declare isoThreshold = 0;						#end
#ifndef(isoSmooth)					#declare isoSmooth = no;						#end
#ifndef(isoNormalAccuracy)			#declare isoNormalAccuracy = .00001;			#end

//Function Extents
#ifndef(isoMin)						#declare isoMin = -<1, 1, 1>;					#end
#ifndef(isoMax)						#declare isoMax = <1, 1, 1>;					#end

//Accuracy
#ifndef(isoSegs)					#declare isoSegs = <10, 10, 10>;				#end

//File tp save in
#ifndef(isoFileOption)				#declare isoFileOption = 0;						#end		//0 = Load, 1 = Save, 2 = Ignore
#ifndef(isoFile)					#declare isoFile = "";							#end
#ifndef(isoName)					#declare isoName = "";							#end

//Function in Question
#ifndef(f)							#declare f = function(x,y,z) {x*x+y*y+z*z-1}	#end

//Compute function extents along each axis
#declare xmin = isoMin.x; #declare xmax = isoMax.x;
#declare ymin = isoMin.y; #declare ymax = isoMax.y;
#declare zmin = isoMin.z; #declare zmax = isoMax.z;

//Number of segments to break the mesh into along each axis
#declare xsegs = isoSegs.x;
#declare ysegs = isoSegs.y;
#declare zsegs = isoSegs.z;

//Size of each step
#declare xstep = (xmax - xmin) / xsegs;
#declare ystep = (ymax - ymin) / ysegs;
#declare zstep = (zmax - zmin) / zsegs;

#declare vertex = array[8]		//Vertex coordinates of each corners of the current grid cell
#declare value = array[8]		//The function values at each grid cell vertex coordinate
#declare triCount = 0;			//Total number of triangles in the mesh

#if(strlen(isoFile) & isoFileOption = 1)
	#declare saveIsoInFile = yes;
#else
	#declare saveIsoInFile = no;
#end

SetGradientAccuracy(isoNormalAccuracy)

#macro makeTri(a, b, c)
	#if(saveIsoInFile)
		#if(isoSmooth)
			#write(isoStream, "smooth_triangle{",a,vGradient(f, a),b,vGradient(f, b),c,vGradient(f, c),"}\n")
		#else
			#write(isoStream, "triangle{",a,b,c,"}\n")
		#end
	#else
		#if(isoSmooth)
			smooth_triangle {a vGradient(f, a) b vGradient(f, b) c vGradient(f, c)}
		#else
			triangle {a b c}
		#end
	#end
#end

#macro interp(a, b, A, B)
	#local Intercept = (B-A)*((isoThreshold-a)/(b-a))+A;
	Intercept
#end

#macro polygonizeTetra(v0, v1, v2, v3)
	#local triIdx = 0;
	#local tri = array[3]
	#local norm = array[3]
	
	#if(value[v0] < 0) #local triIdx = triIdx + 1; #end
	#if(value[v1] < 0) #local triIdx = triIdx + 2; #end
	#if(value[v2] < 0) #local triIdx = triIdx + 4; #end
	#if(value[v3] < 0) #local triIdx = triIdx + 8; #end

	#switch(triIdx)
		#case(1)
		#case(14)
			#local tri[0] = interp(value[v0], value[v1], vertex[v0], vertex[v1]);
			#local tri[1] = interp(value[v0], value[v2], vertex[v0], vertex[v2]);
			#local tri[2] = interp(value[v0], value[v3], vertex[v0], vertex[v3]);
			makeTri(tri[0], tri[1], tri[2])
			#declare triCount = triCount + 1;
			#break
		#case(2)
		#case(13)
			#local tri[0] = interp(value[v1], value[v0], vertex[v1], vertex[v0]);
			#local tri[1] = interp(value[v1], value[v3], vertex[v1], vertex[v3]);
			#local tri[2] = interp(value[v1], value[v2], vertex[v1], vertex[v2]);
			makeTri(tri[0], tri[1], tri[2])
			#declare triCount = triCount + 1;
			#break
		#case(3)
		#case(12)
			#local tri[0] = interp(value[v0], value[v3], vertex[v0], vertex[v3]);
			#local tri[1] = interp(value[v0], value[v2], vertex[v0], vertex[v2]);
			#local tri[2] = interp(value[v1], value[v3], vertex[v1], vertex[v3]);
			makeTri(tri[0], tri[1], tri[2])

			#local tri[0] = tri[2];
			#local tri[2] = tri[1];
			#local tri[1] = interp(value[v1], value[v2], vertex[v1], vertex[v2]);
			makeTri(tri[0], tri[1], tri[2])
			#declare triCount = triCount + 2;
			#break
		#case(4)
		#case(11)
			#local tri[0] = interp(value[v2], value[v0], vertex[v2], vertex[v0]);
			#local tri[1] = interp(value[v2], value[v1], vertex[v2], vertex[v1]);
			#local tri[2] = interp(value[v2], value[v3], vertex[v2], vertex[v3]);
			makeTri(tri[0], tri[1], tri[2])
			#declare triCount = triCount + 1;
			#break
		#case(5)
		#case(10)
			#local tri[0] = interp(value[v0], value[v1], vertex[v0], vertex[v1]);
			#local tri[1] = interp(value[v2], value[v3], vertex[v2], vertex[v3]);
			#local tri[2] = interp(value[v0], value[v3], vertex[v0], vertex[v3]);
			makeTri(tri[0], tri[1], tri[2])

			#local tri[2] = tri[1];
			#local tri[1] = interp(value[v1], value[v2], vertex[v1], vertex[v2]);
			makeTri(tri[0], tri[1], tri[2])
			#declare triCount = triCount + 2;
			#break
		#case(6)
		#case(9)
			#local tri[0] = interp(value[v0], value[v1], vertex[v0], vertex[v1]);
			#local tri[1] = interp(value[v1], value[v3], vertex[v1], vertex[v3]);
			#local tri[2] = interp(value[v2], value[v3], vertex[v2], vertex[v3]);
			makeTri(tri[0], tri[1], tri[2])

			#local tri[1] = interp(value[v0], value[v2], vertex[v0], vertex[v2]);
			makeTri(tri[0], tri[1], tri[2])
			#declare triCount = triCount + 2;
			#break
		#case(7)
		#case(8)
			#local tri[0] = interp(value[v3], value[v2], vertex[v3], vertex[v2]);
			#local tri[1] = interp(value[v3], value[v0], vertex[v3], vertex[v0]);
			#local tri[2] = interp(value[v3], value[v1], vertex[v3], vertex[v1]);
			makeTri(tri[0], tri[1], tri[2])
			#declare triCount = triCount + 1;
			#break
	#end
#end

#macro polygonizeCell()
	polygonizeTetra(0, 2, 3, 7)
	polygonizeTetra(0, 2, 6, 7)
	polygonizeTetra(0, 4, 6, 7)
	polygonizeTetra(0, 6, 1, 2)
	polygonizeTetra(0, 6, 1, 4)
	polygonizeTetra(5, 6, 1, 4)
#end

#macro makeCell()
	#local lessThan = 0; #local greaterThan = 0;
	#local i = 0;
	#while(i < 8)
		#declare value[i] = f(vertex[i].x, vertex[i].y, vertex[i].z);
		#if(value[i] < 0) #local lessThan = lessThan + 1; #end
		#if(value[i] > 0) #local greaterThan = greaterThan + 1; #end
		#local i = i + 1;
	#end
	#if(lessThan & greaterThan)polygonizeCell()#end
#end

#if(saveIsoInFile)
	#fopen isoStream isoFile write
	#if(strlen(isoName))
		#write(isoStream, "#declare ", isoName, " = ")
	#end
	#write(isoStream, "mesh{\n")
#end

#if(isoFileOption != 0)
	#if(isoFileOption = 2)
		mesh {
	#end
		#declare X = xmin;
		#while(X < xmax)
			#declare Y = ymin;
			#while(Y < ymax)
				#declare Z = zmin;
				#while(Z < zmax)
					#declare vertex[0] = <X, Y, Z>;
					#declare vertex[1] = <X+xstep, Y, Z>;
					#declare vertex[2] = <X+xstep, Y, Z+zstep>;
					#declare vertex[3] = <X, Y, Z+zstep>;
					
					#declare vertex[4] = <X, Y+ystep, Z>;
					#declare vertex[5] = <X+xstep, Y+ystep, Z>;
					#declare vertex[6] = <X+xstep, Y+ystep, Z+zstep>;
					#declare vertex[7] = <X, Y+ystep, Z+zstep>;

					makeCell()
	
					#declare Z = Z + zstep;
				#end
				#declare Y = Y + ystep;
			#end
			#declare X = X + xstep;
		#end
	#if(isoFileOption = 2)
		}
	#end
#end

#if(saveIsoInFile)
	#write(isoStream, "}\n")
	#write(isoStream, "#declare triCount = ", triCount, ";")
	#fclose isoStream
#end

#if(isoFileOption != 2)
	#if(strlen(isoFile))
		#if(file_exists(isoFile))
			#include isoFile
		#end
	#end
#end

#debug concat("Triangle Count: ", str(triCount, 0, 0), "\n")