#include "functions.inc"

#declare R=1.4;
#declare R1=R+0.01;
#declare Box = 0;

camera { location  <-1*R, 2*R, -4*R> look_at <0, 0, 0> angle 18}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}

// ----------------------------------------

#declare F = function {f_comma(x,y,z,1)}

#declare Yin =

isosurface {
  function {F(x,y,z)}
        max_gradient 2
        #if (Box=0)
           contained_by{sphere {0,R}}
        #else
          contained_by{box {<-R,-R,-0>,R}}
        #end
}


object {Yin pigment {rgb 0.9}}
object {Yin pigment {rgb 0.5} rotate y*180}

      
#if (Box=0)
  sphere {0,R pigment {rgbt <1,0,0,0.9>}}
#else
  box {<-R,-R,-0.01>,R1 pigment {rgbt <1,0,0,0.9>}}
#end
