#include "functions.inc"

#declare R=4;
#declare R1=R+0.01;
#declare Box = 0;

camera { location  <0*R, 3*R, -4*R> look_at <0, 0, 0> angle 20}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}

// ----------------------------------------

#declare F = function {f_helical_torus(x,y,z,2, 5, 1, 0.1, 1, 0.5, 1, 6, 3, 0)}
 
isosurface {
  function {F(x,y,z)}
        max_gradient 20
        #if (Box=0)
           contained_by{sphere {0,R}}
        #else
          contained_by{box {<-R,-R,-0>,R}}
        #end
        pigment {rgb .9}
        finish {phong 0.5 phong_size 10}
}
      
#if (Box=0)
  sphere {0,R pigment {rgbt <1,0,0,0.9>}}
#else
  box {<-R,-R,-0.01>,R1 pigment {rgbt <1,0,0,0.9>}}
#end
