//Maeder's Owl   Minimal Surface

camera { location  <11, 20, -20> look_at <0, 0, 0> angle 8}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}


#declare Fx = function(u,v){ u*cos(v)-0.5*u*u*cos(2*v) }
#declare Fy = function(u,v){ pow(u,3/2)*cos(v*3/2)*4/3 }
#declare Fz = function(u,v){ -u*sin(v)-0.5*u*u*sin(2*v) }

#include "param.inc"

object {Parametric(Fx,Fy,Fz,<FromU(0),-2*pi>,<1,2*pi>,50,50,"")
  pigment {uv_mapping checker rgb 0.9 rgb 0.85 scale 0.2}
  finish {phong 0.5 phong_size 10}
  no_shadow
}
