//Helix

camera { location  <5, 5, -30> look_at <0, 0, 0> angle 25}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}


#declare Fx = function(u,v){ pow(cos(v),3)*pow(cos(u),3) }
#declare Fy = function(u,v){ pow(sin(v),3)*pow(cos(u),3) }
#declare Fz = function(u,v){ pow(sin(u),3) }

#include "param.inc"


object {Parametric(Fx,Fy,Fz,<-1.4,0>,<1.4,2*pi>,50,50,"")
  pigment {uv_mapping checker rgb 0.95 rgb 0.85 scale 0.1}
  finish {phong 0.5 phong_size 10}
  scale 5
}
