// Helicoid surface

camera { location  <0, 10, -30> look_at <0, 0, 0> angle 15}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

#declare a = 0.5;  

#declare Fx = function(u,v){ v*cos(u) }
#declare Fy = function(u,v){ a*u }
#declare Fz = function(u,v){ v*sin(u) }

#include "param.inc"


object {Parametric(Fx,Fy,Fz,<-3*pi,-2>,<3*pi,2>,150,50,"")
  pigment {uv_mapping checker rgb 0.9 rgb 0.85 scale 0.5}
  finish {phong 0.5 phong_size 10}
  no_shadow
}
