

camera { location  <0, 2, -10> look_at <0, 0, 0> angle 9}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 rgb <.3,.3,.8>] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 0.8}
light_source {<0,0,0> colour rgb 0.5}
light_source {<0,20,-100> colour rgb 0.5}
                     
#declare CassiniSurface = function (x,y,z,a) {
   (pow((x-a),2) + z*z) * (pow((x+a),2) + z*z) - pow(y,4)
   }


isosurface {
  function { CassiniSurface(x,y,z,0.3) }
        max_gradient 3.1
        contained_by{sphere {0,1}} open
        pigment {rgb .9}
        finish {phong 0.5 phong_size 10}
}
   