#declare R=1.3;

camera { location  <1*R, 1*R, -4*R> look_at <0, 0, 0> angle 35}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

// ----------------------------------------
                                
                                
//Moebius strip with inverted interior v-texture
                               

#declare Fx = function(u,v) {cos(u)+v*cos(u/2)*cos(u)}
#declare Fy = function(u,v) {sin(u)+v*cos(u/2)*sin(u)}
#declare Fz = function(u,v) {v*sin(u/2)}
                        
#include "param.inc"

object {Parametric(Fx,Fy,Fz,<0,-0.3>,<2*pi,0.3>,30,30,"")
    texture {
    pigment { uv_mapping 
      function{v*4+0.6}
      colour_map {[0.2 rgb <1,1,0>][0.2 rgb x]
                  [0.6 rgb x][0.6 rgb y]
      }
    }
    finish {
      phong 0.5
      phong_size 10
      }
    }
    interior_texture {
    pigment { uv_mapping 
      function{v*4+0.6}
      colour_map {[0.2 rgb <1,1,0>][0.2 rgb x]
                  [0.6 rgb x][0.6 rgb y]
      }
      scale -1
    }
    finish {
      phong 0.5
      phong_size 10
      }
    }    
    
    
  no_shadow
}
      
      
