// -w240 -h180 +a0.3

camera { location  <0, 15, -20> look_at <0, 2, 0> angle 50}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1.2}

// ----------------------------------------




#declare S = function {
spline {
   cubic_spline
   -1, <-2, 2, 0>, // control point
   00, < 0, 2, 0>, // start
   01, < 2, 2, 0>,
   02, < 5, 3, 0>,
   02.5, < 7, 3, 0>,
   04.5, < 5, 3,-2>,
   05, < 5, 3, 0>,
   06, < 5, 5, 5>,
   07, < 0, 5, 9>,
   08, <-2, 4, 5>,
   09, < 2, 3, 5>,
   10, < 0, 2, 9>,
   11, <-5, 2, 5>,
   12, <-5, 3, 0>,
   12.5, <-5, 3,-2>,
   14.5, <-7, 3, 0>,
   15, <-5, 3, 0>,
   16, <-2, 2, 0>,
   17, < 0, 2, 0>, // stop
   18, < 2, 2, 0>, // control point
   }
}



#declare x1=0;
#declare y1=0;
#declare z1=0;
#declare x2=0;
#declare y2=0;
#declare z2=0;

#declare U = 0;
#while (U < 17)
  sphere {<S(U).x, S(U).y, S(U).z> ,.1  pigment { rgb <1,1,0> } no_shadow}
  //Find the size of the container
  #if (S(U).x < x1)
    #declare x1=S(U).x;
  #end     
  #if (S(U).x > x2)
    #declare x2=S(U).x;
  #end     
  #if (S(U).y < y1)
    #declare y1=S(U).y;
  #end     
  #if (S(U).y > y2)
    #declare y2=S(U).y;
  #end     
  #if (S(U).z < z1)
    #declare z1=S(U).z;
  #end     
  #if (S(U).z > z2)
    #declare z2=S(U).z;
  #end
       
  #declare U = U + 0.01;
#end



#declare Fx = function(x,y) {S(u).x + sin(v)}
#declare Fy = function(x,y) {S(u).y + cos(v)}
#declare Fz = function(x,y) {S(u).z}

#include "param.inc"

object {Parametric(Fx,Fy,Fz,<0,-pi>,<17,pi>,100,30,"")
  pigment {rgbt <1,1,1,0.5>}
  finish {phong 0.5 phong_size 10}
  no_shadow
}


