
camera { location  <2, 4, -8> look_at <0, 0, 0> angle 40}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

// ----------------------------------------
                                
                                
#declare Turns=3;
#declare r1 = 0.3;
#declare r2 = 1.0;
#declare Flute = 0.04;
#declare Freq  = 24;


#declare Fx = function(u,v) {r1*sin(u*Turns) + r2*cos(v) + Flute*sin(Freq*v)}
#declare Fy = function(u,v) {u}
#declare Fz = function(u,v) {r1*cos(u*Turns) + r2*sin(v) + Flute*sin(Freq*v)}
                        
#include "param.inc"

object {Parametric(Fx,Fy,Fz,<-pi,-pi>,<pi,pi>,30,200,"")
  pigment {rgb 0.9}
  finish {phong 0.5 phong_size 10}
  no_shadow
}
      
