
#declare R=2;

camera { location  <1*R, 2*R, -4*R> look_at <0, 0, 0> angle 20}

sky_sphere { pigment {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}

// ----------------------------------------
                                
                                

#declare Fx = function(u,v) {sin(u)*sin(v) +cos(20*v)*0.05}
#declare Fy = function(u,v) {cos(u)*sin(v) +cos(20*u)*0.05}
#declare Fz = function(u,v) {cos(v)}//        +sin(20*u)*0.05}
                        
#include "param.inc"

object {Parametric(Fx,Fy,Fz,<-pi,-pi>,<pi,pi>,100,200,"")
  pigment {rgb 0.9}
  finish {phong 0.5 phong_size 10}
  no_shadow
}
      
