#include "functions.inc"

#declare R=5;
#declare R1=R+0.01;
#declare Box = 0;

camera { location  <-3*R, 2*R, -4*R> look_at <0, 0, 0> angle 30}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<-100,200,-100> colour rgb 1}
light_source {<100,-200,-100> colour rgb 0.5}

// ----------------------------------------

isosurface {
  function { f_enneper(x,y,z,-0.1)}
        max_gradient 2000
        #if (Box=0)
           contained_by{sphere {0,R}} open
        #else
          contained_by{box {<-R,-R,-R>,R}} open
        #end
        pigment {rgb .9}
        finish {phong 0.5 phong_size 10}
}
      
#if (Box=0)
  sphere {0,R pigment {rgbt <1,0,0,0.9>}}
#else
  box {<-R,-R,-R>,R1 pigment {rgbt <1,0,0,0.9>}}
#end
