#include "functions.inc"

camera { location  <0, 1, 4> look_at <0, 0, 0> angle 40}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<-100,200,200> colour rgb 1}

#declare R=1.3;

#declare F=function {f_mesh1(x,y,z,0.15,0.15,1,0.02,1) - 0.03}

isosurface {
  function { F(f_ph(x,y,z), f_r(x,y,z)-1, f_th(x,y,z)) }
        max_gradient 10
        contained_by{sphere {0,R}}
        pigment {rgb .9}
        finish {phong 0.5 phong_size 10}
}

