// -w240 -h180 +a0.3
#include "functions.inc"

camera { location  <-2, 3, -8> look_at <0, 0, 0> angle 50}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] } 
  }
}

light_source {<-100,200,-100> colour rgb 0.6}
light_source {<-50,20,-40> colour rgb 0.6}

// ----------------------------------------

#declare  F = function {f_torus(y,x,z,0.8,0.19)}
#declare Step = 0.75;

isosurface {
  function { F ( mod(abs(x),Step)-Step/2, y, z) }
        max_gradient 1
        contained_by{box{<-5,-1,-1><5,1,1>}}
        pigment {rgb 1}
        finish {phong 0.5 phong_size 10}
}
