#include "functions.inc"

camera { location  <0, 8, -10> look_at <0, 0, 0> angle 20}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<-100,200,-100> colour rgb 1}


#declare R = 1.6;

// ----------------------------------------
#declare  S = function {f_sphere(x,y,z,0.5)}
#declare  T = function {f_torus(x,y,z,1,0.2)}

                     
isosurface {
  function { S(x-0.7,y,z) * T(x,y,z) - 0.05}
        max_gradient 2
        contained_by{sphere{0,R}}
        pigment {rgb .9}
        finish {phong 0.5 phong_size 10}
}

sphere {0,R pigment {rgbt <1,0,0,0.9>}}
