#include "functions.inc"

camera { location  <0, 2,-3> look_at <0, 0.1, 0> angle 40}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<-100,200,-100> colour rgb 1}

// ----------------------------------------


#declare P1=function{pattern{leopard turbulence 0.3 scale 0.2}}

#declare P2=function{pattern{leopard turbulence 0.3 scale 0.5}}

#declare G=pigment{gradient y
         colour_map {[0.04 rgb <0.1,0.4,0.1>]
                     [0.10 rgb <0.5,0.4,0.3>]
                     [0.25 rgb 0.5]
                     [0.65 rgb 1.0]
                     }
         translate -0.05*y
         }
         

isosurface {
  function { y - P1(x,0,z)*0.3 - P2(x,0,z)*1.0}
        max_gradient 2
        contained_by{box{<-2,-0.1,-2>,<2,0.6,2>}}
        pigment {G}
}

box {<-2,-0.1,-2><2,0,2>
     pigment {rgb <0.3,0.4,0.6>}
     rotate x*5
    }