// -w240 -h180 +a0.3
camera { location  <0, 0, -30> look_at <0, -2, 0> angle 25}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,-200,-100> colour rgb 0.5}


#declare R=function(u,v){4*cos(v)*pow(sin(abs(u)),abs(u)) }

#declare Fx = function(u,v){R(u,v)*cos(u)*cos(v)*1.6}
#declare Fy = function(u,v){R(u,v)*sin(u)*cos(v)}
#declare Fz = function(u,v){2*sin(v)}

#include "param.inc"

object{
    Parametric(
       Fx, Fy, Fz,
       <FromU(-pi),-pi/2>,<ToU(pi),pi/2>,
       60,60,""
    )
    pigment {rgb <1,0.4,0.4>}
    finish {
      phong 0.5
      phong_size 10
      }
  no_shadow
  rotate -z*90
  rotate y*0
}

