// -w240 -h180 +a0.3
#include "functions.inc"

camera { location  <0, 0, -3> look_at <0, 0.05, 0> angle 50}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] } 
  }
}

light_source {<100,200,-100> colour rgb 1}
light_source {<-100,100,-100> colour rgb 0.5}


#declare Bend=0.5;
#declare Sharpness=0.8;

isosurface {
  function { f_torus(y-pow(abs(x),Sharpness)*Bend,z,x,0.8,0.1) }
        max_gradient 1.5
        contained_by{sphere {0,1.5}}
        pigment {rgb x}
        finish {phong 1.5 phong_size 50}
}


isosurface {
  function { f_sphere(y-pow(abs(x),Sharpness)*Bend,z*2,x,0.6) }
        max_gradient 2.0
        contained_by{sphere {0,1}}
        pigment {rgb x}
        finish {phong 1.5 phong_size 50}
  rotate y*0
}
