camera { location  <-1, 1, -4> look_at <0, -0.35, 0> angle 20}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<-100,200,-100> colour rgb 1}

// ----------------------------------------

#declare Gravity_Well =  
  function(x,y,z,Strength) {
     x*x -Strength/(y*y) +z*z
  }



isosurface {
  function { Gravity_Well(x,y,z,0.002) }
        max_gradient 20
        contained_by{box {<-1,-1,-1><1,-0.001,1>}}  open
        pigment {rgb .9}
        finish {phong 0.5 phong_size 10}
        no_shadow
}

