// A bent lathe

#version 3.5;

camera { location  <0, 3, -5> look_at <0, 0, 0> angle 30}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-500> colour rgb 1}

// The open 1D spline (lathe) 
#declare S = function {
   spline {
     natural_spline
      -1, < 1.0, 0, 0>,
    -0.8, < 0.4, 0, 0>,
    -0.5, < 0.2, 0, 0>,
    -0.2, < 0.2, 0, 0>,
     0.3, < 0.8, 0, 0>,
       1, < 1.0, 0, 0>
   }
 }

// Another open spline, 2D (along which the lathe is bent)
#declare S2 = function {
   spline {
     natural_spline
      -1, < 0.1, 0,-0.2>,
    -0.5, < 0.2, 0, 0.0>,
     0.5, < 0.0, 0, 0.0>,
       1, < 0.2, 0, 0.2>
   }
 }


#declare Fx = function(x,y) {(S(u).x * sin(v)/2) + S2(u).x}
#declare Fy = function(x,y) {u}
#declare Fz = function(x,y) {(S(u).x * cos(v)/2) + S2(u).z}

#include "param.inc"

object {Parametric(Fx,Fy,Fz,<-1,-pi>,<1,pi>,20,50,"")
        pigment {rgb .9}
        finish {phong 0.5 phong_size 10 ambient 0.2}
} 

