// -w240 -h180 +a0.3

camera { location  <0, 15, -20> look_at <0, 2, 0> angle 45}

sky_sphere { pigment {
    function{abs(y)}
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source {<100,200,-100> colour rgb 1.2}

// ----------------------------------------




#declare S = function {
spline {
   cubic_spline
   -1, <-2, 2, 0>, // control point
   00, < 0, 2, 0>, // start
   01, < 2, 2, 0>,
   02, < 5, 3, 0>,
   02.5, < 7, 3, 0>,
   04.5, < 5, 3,-2>,
   05, < 5, 3, 0>,
   06, < 5, 5, 5>,
   07, < 0, 5, 9>,
   08, <-2, 4, 5>,
   09, < 2, 3, 5>,
   10, < 0, 2, 9>,
   11, <-5, 2, 5>,
   12, <-5, 3, 0>,
   12.5, <-5, 3,-2>,
   14.5, <-7, 3, 0>,
   15, <-5, 3, 0>,
   16, <-2, 2, 0>,
   17, < 0, 2, 0>, // stop
   18, < 2, 2, 0>, // control point
   }
}


#declare The_Path = union {
   #declare U = 0;
   #while (U < 17)
      sphere {<S(U).x, S(U).y, S(U).z> ,.1}
      #declare U = U + 0.01;
   #end
}


#declare Fx = function(x,y) {S(u).x + sin(v)}
#declare Fy = function(x,y) {S(u).y + cos(v)}
#declare Fz = function(x,y) {S(u).z}

#include "param.inc"

object {Parametric(Fx,Fy,Fz,<0,-pi>,<17,pi>,100,20,"")
  pigment {rgbt <1,1,1,0.4>}
  finish {phong 0.5 phong_size 10}
  no_shadow
}

object {The_Path
  pigment { rgb <1,1,0> }
  no_shadow
}