GLOBAL_Forest = new Heap(Tree_CompareFreq);
GLOBAL_SVG = "http://www.w3.org/2000/svg";

function DrawForest()
{
  // Get image.
  var image = document.getElementById("forest");

  // Get tfreq.
  var tfreq = document.getElementById("dec-text").value.length;

  // Erase image.
  while (image.children.length > 0) image.removeChild(image.children[0]);

  // Draw title.
  var item = document.createElementNS(GLOBAL_SVG, "text");
  item.setAttribute("x", (10 - 2) + "cm");
  item.setAttribute("y", "5mm");
  item.setAttribute("textLength", "2cm");
  item.setAttribute("class", "title");
  var text = document.createTextNode("Huffman forest");
  item.appendChild(text);
  image.appendChild(item);

  // Draw trees.
  var heap = GLOBAL_Forest;
  var n = 0;
  while (heap.Size > 0)
  {
    var tree = heap.GetMin();
    heap = heap.DeleteMin();

    RAW_DrawTree(image, GLOBAL_Forest.Size, n, 0, 0, tree);
    n++;
  }
}

function DrawTree(image, tree, tfreq)
{
  var heap = new Heap(Tree_CompareFreq);
  heap = heap.Insert(tree);
  DrawForest(image, heap, tfreq);
}

function PosX(ntrees, ntree, row, col)
{
  var siblings = 1;
  for (var lp=0; lp<row; lp++) siblings = siblings*2;

  return ((ntree*siblings + col + 1) / (ntrees*siblings + 1)) * 200; // mm
}

function PosY(ntrees, ntree, row, col)
{
  return (20 + row*15); // mm
}

function RAW_DrawTree(image, ntrees, ntree, row, col, tree)
{
  var X = PosX(ntrees, ntree, row, col);
  var Y = PosY(ntrees, ntree, row, col);

  if (tree.IsLeaf)
  {
    // Node
    var item = document.createElementNS(GLOBAL_SVG, "circle");
    item.setAttribute("id", "node-" + tree.ID);
    item.setAttribute("class", "leaf");
    item.setAttribute("r", "3mm");
    item.setAttribute("cx", X + "mm");
    item.setAttribute("cy", Y + "mm");
    image.appendChild(item);

    // Symbol text
    Draw_CenterText(image, X, Y, "[" + tree.Symbol + "]", "symbol");

    // Weight text
    Draw_CenterText(image, X, Y - 05, "" + tree.Freq, "weight");

    // Codeword text
    Draw_CenterText(image, X, Y + 05, "[" + tree.Code + "]", "codeword");
  }
  else
  {
    // Node
    var item = document.createElementNS(GLOBAL_SVG, "circle");
    item.setAttribute("id", "node-" + tree.ID);
    item.setAttribute("class", "branch");
    item.setAttribute("r", "2mm");
    item.setAttribute("cx", X + "mm");
    item.setAttribute("cy", Y + "mm");
    image.appendChild(item);

    // Lines
    var X0 = PosX(ntrees, ntree, row+1, col*2 + 0);
    var Y0 = PosY(ntrees, ntree, row+1, col*2 + 0);
    var X1 = PosX(ntrees, ntree, row+1, col*2 + 1);
    var Y1 = PosY(ntrees, ntree, row+1, col*2 + 1);
    Draw_Line(image, X, Y, X0, Y0);
    Draw_Line(image, X, Y, X1, Y1);

    // Weight text
    Draw_CenterText(image, X, Y - 05, "" + tree.Freq, "weight");

    // Codeword text
    Draw_CenterText(image, X, Y + 05, "[" + tree.Code + "]", "codeword");

    RAW_DrawTree(image, ntrees, ntree, row+1, col*2 + 0, tree.Child0);
    RAW_DrawTree(image, ntrees, ntree, row+1, col*2 + 1, tree.Child1);
  }
}

function Draw_Line(image, x1, y1, x2, y2)
{
  item = document.createElementNS(GLOBAL_SVG, "line");
  item.setAttribute("x1", x1  + "mm");
  item.setAttribute("y1", y1  + "mm");
  item.setAttribute("x2", x2 + "mm");
  item.setAttribute("y2", y2 + "mm");
  image.appendChild(item);
}

function Draw_CenterText(image, x, y, msg, class_name)
{
  var size = msg.length * 02;

  var txt = document.createElementNS(GLOBAL_SVG, "text");
  txt.setAttribute("class", class_name);
  txt.setAttribute("x", (x - size/2) + "mm");
  txt.setAttribute("y", (y +     01) + "mm");
  text = document.createTextNode(msg);
  txt.appendChild(text);
  image.appendChild(txt);
}

function NodeSetClass(tree, class_name)
{
  var node = document.getElementById("node-" + tree.ID);
  node.setAttribute("class", class_name);
}

function NodeUnsetClass(id)
{
  var node = document.getElementById("node-" + id);
  if (node.IsLeaf) node.setAttribute("class", "leaf");
  else             node.setAttribute("class", "branch");
}
