var GLOBAL_Child0 = null;
var GLOBAL_Child1 = null;

function UI_InitCompress()
{
  var step1 = null;
  var step2 = null;
  var step3 = null;

  step2 = new StepInfo("A. Count character frequencies", Step2_CountFreq);
  step1 = new StepInfo_Sub("1. Build Huffman code", step2);
  GLOBAL_Steps = step1;

  step3 = new StepInfo("a. Find lowest node", Step3_HuffmanGet0);
  step2.NextStep = new StepInfo_While("B. Build Huffman subtree", Pred_HuffmanBuild, step3); step2 = step2.NextStep;
  step3.NextStep = new StepInfo("b. Find lowest node", Step3_HuffmanGet1); step3 = step3.NextStep;
  step3.NextStep = new StepInfo("c. Insert new subtree", Step3_HuffmanPut); step3 = step3.NextStep;

  step3 = new StepInfo("a. Sort symbols", Step3_SortSymbols);
  step2 = new StepInfo_Sub("A. Save Huffman code", step3);
  step1.NextStep = new StepInfo_Sub("2. Convert to canonical form", step2); step1 = step1.NextStep;
  step3.NextStep = new StepInfo("b. Output code description", Step3_WriteCode);

  stepX = new StepInfo("I. Load next symbol.", Step3_LoadNextSymbol);
  step3 = new StepInfo_While("a. Load next symbol", Pred_HuffmanLoad, stepX);
  step2.NextStep = new StepInfo_Sub("B. Load Huffman code", step3);

  step3 = new StepInfo("a. Read character", Step3_ReadSymbol);
  step2 = new StepInfo_While("A. Encode character", Pred_HuffmanEncode, step3);
  step1.NextStep = new StepInfo_Sub("3. Encode characters", step2);
  step3.NextStep = new StepInfo("b. Write bits", Step3_WriteBits);

  GLOBAL_Symbols = null;
  PrintSymbols();

  GLOBAL_Forest = new Heap(Tree_CompareFreq);
  DrawForest();

  GLOBAL_EncChars = null;
  GLOBAL_EncBits  = 0;
  PrintStatsEnc();
  PrintStatsFinal();

  GLOBAL_DecIndex = null;
  GLOBAL_EncIndex = null;
  document.getElementById("enc-text").value = "";

  GLOBAL_HuffmanLoad  = true;
  GLOBAL_CodeSize     = null;
  GLOBAL_NextCode     = null;
}

/////////////////////////////////////////////////////////////////////

function Step2_CountFreq()
{
  GLOBAL_Symbols = null;

  var text = document.getElementById("dec-text").value;
  var list = CountFreq(text);
  GLOBAL_Symbols = Sort(list, Tree_CompareSymbol);
  PrintSymbols();

  GLOBAL_Forest = ListToHeap(list, Tree_CompareFreq);
  DrawForest();

  return this.DoneStep();
}

/////////////////////////////////////////////////////////////////////

function Pred_HuffmanBuild()
{
  return (GLOBAL_Forest.Size >= 2);
}

function Step3_HuffmanGet0()
{
  // Clear any existing hilighting.
  PrintSymbols();
  DrawForest();

  GLOBAL_Child0 = GLOBAL_Forest.GetMin();
  GLOBAL_Forest = GLOBAL_Forest.DeleteMin();
  RowsSetClass(GLOBAL_Child0, "child0");
  NodeSetClass(GLOBAL_Child0, "child0");
  return this.DoneStep();
}

function Step3_HuffmanGet1()
{
  GLOBAL_Child1 = GLOBAL_Forest.GetMin();
  GLOBAL_Forest = GLOBAL_Forest.DeleteMin();
  RowsSetClass(GLOBAL_Child1, "child1");
  NodeSetClass(GLOBAL_Child1, "child1");
  return this.DoneStep();
}

function Step3_HuffmanPut()
{
  var tree = new Branch(GLOBAL_Child0, GLOBAL_Child1);
  GLOBAL_Child0 = null;
  GLOBAL_Child1 = null;

  GLOBAL_Forest = GLOBAL_Forest.Insert(tree);
  PrintSymbols();
  RowsSetClass(tree, "new");
  DrawForest();
  NodeSetClass(tree, "new");
  return this.DoneStep();
}

/////////////////////////////////////////////////////////////////////

function Step3_SortSymbols()
{
  // Clear existing hilighting.
  DrawForest();

  GLOBAL_Symbols = Sort(GLOBAL_Symbols, Tree_CompareBits);
  PrintSymbols();

  return this.DoneStep();
}

function Step3_WriteCode()
{
  var out = document.getElementById("enc-text");
  out.value = "";

  var list = GLOBAL_Symbols;
  while (list != null)
  {
    var size = list.Data.Code.length;
    out.value = out.value + size + "={";

    var go = true;
    while (go)
    {
      out.value = out.value + "[" + list.Data.Symbol + "]";
      list = list.Next;
      go = (list != null);
      if (go) {go = (list.Data.Code.length == size);}
    }

    out.value = out.value + "}; ";
  }
  out.value = out.value + "#\n\n";

  return this.DoneStep();
}

/////////////////////////////////////////////////////////////////////

var GLOBAL_HuffmanLoad = true;

function Pred_HuffmanLoad() {return GLOBAL_HuffmanLoad;}

function EncRead_BitLength()
{
  var c = GetEncChar();
  while (!(c >= '0' & c <= '9') & c != '#') {c = GetEncChar();}

  if (c == '#') return null;

  var num = "";
  while (c >= '0' & c <= '9')
  {
    num = num + c;
    c = GetEncChar();
  }

  while (c != '{') {c = GetEncChar();}
  return (num * 1);
}

function EncRead_Symbol()
{
  var c = GetEncChar();
  while (c != '[' & c != '}') {c = GetEncChar();}
  if (c == '[') return GetEncChar();
  return null;
}

var GLOBAL_NextCode = null;
var GLOBAL_CodeSize = null;

function PrintNextCode(class_name)
{
  var dom = document.getElementById("next-code")
  dom.innerHTML = "<code>[" + GLOBAL_NextCode + "]</code>";
  dom.className = class_name;
}

function IncNextCode()
{
  var lp=GLOBAL_NextCode.length-1;
  var out = "";
  while (GLOBAL_NextCode[lp] == '1')
  {
    out = '0' + out;
    lp--;
  }
  out = '1' + out; lp--;
  while (lp >= 0)
  {
    out = GLOBAL_NextCode[lp] + out;
    lp--;
  }
  GLOBAL_NextCode = out;
}

function Step3_LoadNextSymbol()
{
  // Clear codes
  if (GLOBAL_EncIndex == null)
  {
    ResetEnc();

    GLOBAL_Forest = new Heap(Tree_CompareFreq);
    DrawForest();

    var list = GLOBAL_Symbols;
    while (list != null)
    {
      list.Data.Code = "?";
      list = list.Next;
    }
    PrintSymbols();
  }

  // Get size
  if (GLOBAL_CodeSize == null)
  {
    GLOBAL_CodeSize = EncRead_BitLength();

    // Check for end of table.
    if (GLOBAL_CodeSize == null)
    {
      GLOBAL_NextCode = null;
      GLOBAL_CodeSize = null;
      GLOBAL_EncIndex = null;
      PrintSymbols();
      GLOBAL_HuffmanLoad = false;
      return this.DoneStep();
    }

    if (GLOBAL_NextCode == null) GLOBAL_NextCode = "";

    while (GLOBAL_NextCode.length < GLOBAL_CodeSize)
    GLOBAL_NextCode = GLOBAL_NextCode + '0';

    PrintSymbols(); // Clear any hilighting.
    PrintNextCode("enlarge");
  }
  else
  {
    var symbol = EncRead_Symbol();

    // Check for end of row.
    if (symbol == null)
    {
      GLOBAL_CodeSize = null;
      PrintSymbols(); // Clear any hilighting.
      PrintNextCode("");
      return this.DoneStep();
    }

    // Add code to symbol table.
    var list = GLOBAL_Symbols;
    while (list.Data.Symbol != symbol) list = list.Next;
    list.Data.Code = GLOBAL_NextCode;
    PrintSymbols();
    RowsSetClass(list.Data, "new");

    IncNextCode();
    PrintNextCode("incr");
  }

  return this.DoneStep();
}

/////////////////////////////////////////////////////////////////////

function Pred_HuffmanEncode() {return !GLOBAL_DecEOF;}

function Step3_ReadSymbol()
{
  // Reset input stream if necessary.
  if (GLOBAL_DecIndex == null) {ResetEnc(); ResetDec();}

  // Read symbol.
  var symbol = GetDecChar();

  // Look up symbol.
  var list = GLOBAL_Symbols;
  while (list.Data.Symbol != symbol) list = list.Next;

  // Hilight symbol.
  RowsSetClass(list.Data, "new");

  return this.DoneStep();
}

function Step3_WriteBits()
{
  // Get symbol
  var symbol = PeekDecChar(-1);

  // Look up symbol.
  var list = GLOBAL_Symbols;
  while (list.Data.Symbol != symbol) list = list.Next;
  var leaf = list.Data;

  // Output symbol.
  WriteEnc(leaf.Code + " ");

  // Unlilight symbol.
  RowsSetClass(leaf, "");

  // Update statistics.
  if (GLOBAL_EncChars == null) GLOBAL_EncChars = 1; else
  GLOBAL_EncChars++;
  GLOBAL_EncBits += leaf.Code.length;
  PrintStatsEnc();
  PrintStatsFinal();

  return this.DoneStep();
}
