function ListNode(data, next)
{
  this.Data = data;
  this.Next = next;
}

function Sort(list_in, compare)
{
  var heap = ListToHeap(list_in, compare);
  return HeapToList(heap);
}

function ListToHeap(list_in, compare)
{
  var heap = new Heap(compare);
  var list = list_in;
  while (list != null)
  {
    heap = heap.Insert(list.Data);
    list = list.Next;
  }

  return heap;
}

function HeapToList(heap_in)
{
  if (heap_in.Size == 0) return null;

  var out  = new ListNode(heap_in.GetMin(), null);
  var list = out;
  var heap = heap_in.DeleteMin();
  while (heap.Size > 0)
  {
    list.Next = new ListNode(heap.GetMin(), null);
    list = list.Next;
    heap = heap.DeleteMin();
  }

  return out;
}
