var GLOBAL_NodeID = 0;

function Leaf(symbol, freq)
{
  this.IsLeaf = true;
  this.Symbol = symbol;
  this.Freq   = freq;
  this.Code   = "";
  this.Depth  = 1;
  this.Label  = Leaf_Label;
  this.ID     = GLOBAL_NodeID;
  GLOBAL_NodeID++;
}

function Branch(child0, child1)
{
  this.IsLeaf = false;
  this.Symbol = ""; // For sorting purposes.
  this.Child0 = child0;
  this.Child1 = child1;
  this.Freq   = child0.Freq + child1.Freq;
  this.Code   = "";
  this.Depth  = child0.Depth + 1;
  if (child1.Depth > child0.Depth)
  this.Depth  = child1.Depth + 1;
  this.Label  = Branch_Label;
  child0.Label("0");
  child1.Label("1");
  this.ID     = GLOBAL_NodeID;
  GLOBAL_NodeID++;
}

function   Leaf_Label(bit) {this.Code = bit + this.Code;}
function Branch_Label(bit)
{
  this.Code = bit + this.Code;
  this.Child0.Label(bit);
  this.Child1.Label(bit);
}

function Tree_CompareFreq(x, y)
{
  if ( x.Freq   != y.Freq  ) return x.Freq   < y.Freq;
  if ( x.Depth  != y.Depth ) return x.Depth  < y.Depth;
  if ( x.Symbol != y.Symbol) return x.Symbol < y.Symbol;
  return Tree_CompareFreq(x.Child0, y.Child0);
}

function Tree_CompareSymbol(x, y)
{
  return x.Symbol < y.Symbol;
}

function Tree_CompareBits(x, y)
{
  if (x.Code.length != y.Code.length) return x.Code.length < y.Code.length;
  return x.Symbol < y.Symbol;
}

function ListNode(data, next)
{
  this.Data = data;
  this.Next = next;
}

function CountFreq(text)
{
  if (text.length < 1) return null;

  var list = new ListNode(new Leaf(text[0], 1), null);
  for (var lp=1; lp<text.length; lp++)
  {
    var cursor = list;
    while (cursor.Data.Symbol != text[lp])
    {
      if (cursor.Next == null) cursor.Next = new ListNode(new Leaf(text[lp], 0), null);
      cursor = cursor.Next;
    }
    cursor.Data.Freq++;
  }

  return list;
}
