// MESH.FX
//
// FX file for rendering meshes, including single rendering and multi-rendering
// with VS constant instancing


// data from code
float4x4 mWorldViewProj : WORLDVIEWPROJECTION;

float3 lightPos1;     // light direction
float3 cameraPos;    // camera position

float ambient = 0.4;

float scale;

float delta = 0.0001;

// texture samplers


// Vertex Shader
struct VS_INPUT
{
	float3 pos  : POSITION;
	float3 norm : NORMAL0;
	float2 tex  : TEXCOORD0;
	float  instance : TEXCOORD1;
};


struct VS_OUTPUT
{
	float4 pos         : POSITION;
	float4 diffuse     : TEXCOORD1;
};

float4 positionRotation[200]; // define the 200 constansts for instances
float nInstances;


VS_OUTPUT VS_Multi( VS_INPUT vs_in )
{
	if( vs_in.instance >= nInstances ) return (VS_OUTPUT)0;

	VS_OUTPUT Out = (VS_OUTPUT)0;
	
	Out.pos = mul( float4(vs_in.pos * scale + positionRotation[ vs_in.instance ].xyz,1) , mWorldViewProj );

	Out.diffuse = float4( 0.5+0.5*sin(vs_in.instance) , 0.5+0.5*sin(vs_in.instance+2.1) , 0.5+0.5*sin(vs_in.instance-2.1) , 1 );
	
		
	return Out;
}

float sphere(float3 p , float3 c ,float r)
{
	return dot( p-c ,p-c ) - r;
}

float isosurface(float3 p)
{
    // at the moment this is just the isosurface of a sphere with radius 1.0
    // return (pos.x*2)*(pos.x*2) + pos.y*pos.y + pos.z*pos.z - 0.9;
    
    return sphere(p , float3(0,0,0) , 1 ) + 0.05 * (sin(20*p.y) + cos(20*p.x)) + 0.25;
}

float isosurfaceGradientDir(float3 pos , float3 dir)
{

	return ( isosurface(pos+dir*delta) - isosurface(pos) ) / delta;
}

float3 isosurfaceGradient(float3 pos)
{
	float3 grad;
	grad.x = isosurfaceGradientDir(pos , float3(1,0,0) );
	grad.y = isosurfaceGradientDir(pos , float3(0,1,0) );
	grad.z = isosurfaceGradientDir(pos , float3(0,0,1) );
	return grad;
}


// pixel shader
float4 PS2(VS_OUTPUT ps_in) : COLOR
{
	

   return ps_in.diffuse;
	
}
	
	



// FX file info
technique MeshMulti
{
	pass P0
	{
		ZEnable = true;
		ZWriteEnable = true;
		
		AlphaBlendEnable = true;

		SrcBlend  = SRCALPHA;
		DestBlend = INVSRCALPHA;
		
		AlphaTestEnable = true;
		AlphaFunc = GreaterEqual;
		AlphaRef  = 1;
		
		VertexShader = compile vs_2_0 VS_Multi();
		PixelShader = compile ps_2_0 PS2();
	}
}

