// Persistence of Vision Ray Tracer Scene Description File
// File: shadow_prob.pov
// Vers: 3.1

/* If you render this, I have said on the "card" 
what the problem and where it is, that way you should get 
a fair idea of the trouble I'm having.
You will notice I have made a distinction between the 
2 pieces of the card through the use of the ambient, and diffuse.
Thanks in advance for you help
Cheers 
Zane
zharris@galaxycom.net.nz
*/

#version 3.1

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
}

camera {
   location  < 12.0, 18.0, -65.0>
   direction <  0.0,  0.0,   2.0  >
   up        <  0.0,  1.0,   0.0  >
   right     <  4/3,  0.0,   0.0  >
   look_at   <  0.0,  0.0,   0.0  >
} 

// -----Light Source--------------------------------------   
//light_source { <100.0, -15.0, -500.0> colour Gray95 }
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-1.5, 10, -20>
}

// ----------------------------------------
plane
{
  y, -1
  texture
  {
    pigment { color blue 1 }
    finish {reflection 0.00001}
  }
  
}

#declare card_face =
polygon {
    4,
    <0, -1>, <0, 0>, <.9, 0>, <.9, -1>
    texture {
      finish { ambient .4 diffuse .5 }
      pigment { image_map { gif "rose_for_pov.gif" } }
    }
    scale 15
    
    
  } 

#declare card_text =
polygon {
    4,
    <0, -1>, <0, 0>, <.9, 0>, <.9, -1>
    texture {
      finish { ambient .6 diffuse 0 }
      pigment { image_map { gif "text_for_pov.gif" } }
    }
    scale 15
} 

object { card_face  rotate <0, 62, 0> translate <-3, 12.55, 10> }
object { card_text  rotate <0,-15, 0> translate <-3, 12.55, 10> }