/*************************************************************************
        TRIANGLE MAPPING MACRO FILE FOR PERSISTENCE OF VISION 3.1
**************************************************************************

Created by Chris Colefax, 1 June 1999;
   Updated 12 September 1999: renamed macros, improved memory use,
      added full mesh {} support.

*************************************************************************/

// COMMON TRANSFORMATION MACRO (REQUIRED FOR BOTH MAPPING METHODS)
   #macro tri_matrix() #local NX = P2-P1; #local NY = P3-P1; #local NZ = vcross(NX, NY); matrix <NX.x, NX.y, NX.z, NY.x, NY.y, NY.z, NZ.x, NZ.y, NZ.z, P1.x, P1.y, P1.z> #end

// COLOURED VERTEX MACROS
   #ifndef (triangle_base_texture) #declare triangle_base_texture = texture {} #end
   #macro get_cv_texture () texture {triangle_base_texture pigment {
      #if (C1.red=C2.red & C1.red=C3.red & C1.green=C2.green & C1.green=C3.green & C1.blue=C2.blue & C1.blue=C3.blue & C1.filter=C2.filter & C1.filter=C3.filter & C1.transmit=C2.transmit & C1.transmit=C3.transmit) C1 #else
      average pigment_map {[1 gradient x color_map {[0 rgb 0] [1 C2*3]}] [1 gradient y color_map {[0 rgb 0] [1 C3*3]}] [1 gradient z color_map {[0 rgb 0] [1 C1*3]}]}
      matrix <1.01, 0, 1, 0, 1.01, 1, 0, 0, 1, -.002, -.002, -1> tri_matrix() #end }} #end
   #macro cv_triangle (P1, C1, P2, C2, P3, C3) #local T = get_cv_texture () triangle {P1, P2, P3 texture {T}} #end
   #macro cv_smooth_triangle (P1, N1, C1, P2, N2, C2, P3, N3, C3) #local T = get_cv_texture () smooth_triangle {P1, N1, P2, N2, P3, N3 texture {T}} #end

// UV-TEXTURE MAP MACROS
   #macro uv_matrix() #local CX = C2-C1; #local CY = C3-C1; #local CF = 1/(CX.x*CY.y-CY.x*CX.y); matrix <CY.y*CF, -CX.y*CF, 0, -CY.x*CF, CX.x*CF, 0, 0, 0, 1, (CY.x*C1.y-C1.x*CY.y)*CF, (C1.x*CX.y-CX.x*C1.y)*CF, 0> #end
   #macro uv_triangle (P1, C1, P2, C2, P3, C3) #local T = texture {uv_texture uv_matrix() tri_matrix()} triangle {P1, P2, P3 texture {T}} #end
   #macro uv_smooth_triangle (P1, N1, C1, P2, N2, C2, P3, N3, C3) #local T = texture {uv_texture uv_matrix() tri_matrix()} smooth_triangle {P1, N1, P2, N2, P3, N3 texture {T}} #end
   #macro map_uv_texture (T, C1, C2, C3) texture {T uv_matrix() transform _UVT} #end
   #macro uvl_triangle (P1, P2, P3) #declare _UVT = transform {tri_matrix ()} triangle {P1, P2, P3 #end
   #macro uvl_smooth_triangle (P1, N1, P2, N2, P3, N3) #declare _UVT = transform {tri_matrix()} smooth_triangle {P1, N1, P2, N2, P3, N3 #end
