/*





*/

#version 3.7 ;


#ifndef( Colors_Temp)		#include "colors.inc"	#end
#ifndef( Strings_Temp)		#include "strings.inc"	#end


// -------------------------------------------------------------------
// Surface of earth, including blue sky and clouds
// See:
// http://www.f-lohmueller.de/pov_tut/backgrnd/p_sky1.htm
// -------------------------------------------------------------------
#macro Earth_Surface ()

	#local mCloudRotate	= 0;
	#local mTransmit	= 0;

	//clouds in the sky
	plane{
		<0,1,0>,1 hollow
		texture {
			pigment {
				bozo turbulence 0.75 octaves 6  omega 0.7 lambda 2
				color_map {
					[0.0  color rgb <0.95, 0.95, 0.95> ]
					[0.05  color rgb <1, 1, 1>*1.25 ]
					[0.15 color rgb <0.85, 0.85, 0.85> ]
					[0.55 color rgbt <1, 1, 1, 1>*1 ]
					[1.0 color rgbt <1, 1, 1, 1>*1 ]
				}
				translate <-mCloudRotate/2+1,0, mCloudRotate + 3>
				translate< 30, 0,-1>
				scale <0.3, 0.4, 0.2>*3
				}
			finish {emission 1 diffuse 0}
		}
		scale 200
	}

	//sky - blue background
	//gets dimmed while tussi flies through the clouds
	plane {
		<0,1,0>,1 hollow
		texture {
			pigment { color rgb<0.1,0.3,0.75>*0.7 transmit mTransmit }
			finish { emission 1 diffuse 0}
		}
		scale 10000
	}

	//Fog at the horizon
	fog {
		fog_type   2
		distance   1000
		color      rgb<1,1,1>*0.9 * (1-(mTransmit*0.5))
		fog_offset 0.1
		fog_alt    20
		turbulence 1.8
	}

   //Earth Surface
	plane {
		<0,1,0>, 0
		texture {
			pigment { color rgb<0.35,0.65,0.0>*0.6 }
			normal { bumps 0.75 scale 0.015}
			finish { ambient 0.1 diffuse 0.8}
			scale 30
		}
	}
#end


/* ****************************************************************************************************************************
Shows a chess-like testarea
Date: 18.4.19
*/// **************************************************************************************************************************
#macro MA_Testarea      (mAll)
	MA_Testarea_Base    (mAll, mAll, mAll, mAll)
#end
#macro MA_Testarea_Base (mXN, mXP, mZN, mZP)
	#local mThickness	= 0.02;
	#local mBorderTex	= texture { pigment { color Black } }
	#local mVar1		= 0.5;
	#local mVar2		= 0.48;
	#local mResult = union {
		#for (mX, -mXN, mXP, 1)
			#for (mZ, -mZN, mZP, 1)
				//Check out the color-set for a chess-like pattern
				#if ((abs(mod(mX, 2)) = 1 & abs(mod(mZ,2)) = 0) | (abs(mod(mX, 2)) = 0 & abs(mod(mZ,2)) = 1))
					#local mTexture = texture { pigment { color Gray80 } }
				#else
					#local mTexture = texture { pigment { color Gray10 } }
				#end
				//Set the center-field to a different texture
				#if (1 & (mX = 0 & mZ = 0))
					#local mTexture = texture { pigment { color rgb <5,1,1>/5 } }
				#end
				//Border (bit below)
				box { <mX - mVar1, -mThickness, mZ - mVar1>, <mX + mVar1, -0.05, mZ + mVar1>
					texture { mBorderTex }
				}
				//Field (hides most of the border)
				box { <mX - mVar2, -mThickness, mZ - mVar2>, <mX + mVar2, 0, mZ + mVar2>
					texture { mTexture }
				}
			#end
		#end
	}
	object { mResult }
#end

/* ****************************************************************************************************************************
Marks the center with a sphere and the axes with slim lines/cylinders.
Date: 18.4.19
*/// **************************************************************************************************************************
#macro MA_CenterMarker (mLengthAxes)
	MA_CenterMarker_Base (0.1, 0.030, mLengthAxes + 0.5, <1,1,1>)
#end
#macro MA_CenterMarker_Base (mRadiusSphere, mThicknessAxes, mLengthAxes, mAxes)
	#local mAxesTexture = texture {
				pigment { color <0,1,0> }
				finish  { reflection 0.1 phong 1}
			}
	#local mResult = union {
		sphere {
			0, mRadiusSphere
			texture {
				pigment { color rgbt <0.9, 0.1, 0.1, 0.3> }
				finish  { phong 1 }
			}
		}
		#if (mAxes.x) cylinder { <-mLengthAxes, 0, 0>, <+mLengthAxes, 0, 0>, mThicknessAxes texture { mAxesTexture }	} #end
		#if (mAxes.y) cylinder { <0, -mLengthAxes, 0>, <0, +mLengthAxes, 0>, mThicknessAxes texture { mAxesTexture }	} #end
		#if (mAxes.z) cylinder { <0, 0, -mLengthAxes>, <0, 0, +mLengthAxes>, mThicknessAxes texture { mAxesTexture }	} #end
	}
	object { mResult no_shadow no_reflection}
#end

