// Vers: 3.7
// Auth: Leroy Whetstone 
// Email whetstoneleroy@gmail.com
//====================================================================
#version 3.7;
global_settings {assumed_gamma 1 max_trace_level 20}

#include "colors.inc"

camera{ location <0,0,-10>
        look_at <0,0,0>
        right x*image_width/image_height
        }
 light_source{<-10,10,-20> color White parallel point_at 0}
 light_source{<10,-10,-20> color White parallel point_at 0}

#include"TestData4.inc"

#declare Sc= <5,3,2>;
#declare Rot= <-45,0,0>;
#declare Eps= -.75;
#declare Cut= 3;//x=1 y=2; z=3


#declare Vs=dimension_size(Data_Vectors,1)-1;
#declare Fs=dimension_size(Data_Faces,1)-1;
#declare Es=dimension_size(Data_Edges,1)-1;

#for(i,0,Es)
 #declare V1=Data_Vectors[Data_Edges[i].x];
 #declare V2=Data_Vectors[Data_Edges[i].y];
 #if(Cut=1) #if((V1.x>=Eps)&(V2.x>=Eps))cylinder{V1*Sc,V2*Sc,.05 pigment{Red} rotate Rot}#end #end//dome
 #if(Cut=2) #if((V1.y>=Eps)&(V2.y>=Eps))cylinder{V1*Sc,V2*Sc,.05 pigment{Red} rotate Rot}#end #end//dome
 #if(Cut=3) #if((V1.z>=Eps)&(V2.z>=Eps))cylinder{V1*Sc,V2*Sc,.05 pigment{Red} rotate Rot}#end #end//dome
 //cylinder{V1*Sc,V2*Sc,.05 pigment{Red} rotate Rot}
#end

#for(i,0,Vs)
  #if(Cut=1)  #if(Data_Vectors[i].x>=Eps) sphere{Data_Vectors[i]*Sc,.1 pigment{Blue}rotate Rot}#end #end//dome
  #if(Cut=2)  #if(Data_Vectors[i].y>=Eps) sphere{Data_Vectors[i]*Sc,.1 pigment{Blue}rotate Rot}#end #end//dome
  #if(Cut=3)  #if(Data_Vectors[i].z>=Eps) sphere{Data_Vectors[i]*Sc,.1 pigment{Blue}rotate Rot}#end #end//dome
  //sphere{Data_Vectors[i]*Sc,.1 pigment{Blue}rotate Rot} 
#end  

#for(i,0,Fs)
 #declare a=Data_Faces[i].x;
 #declare b=Data_Faces[i].y;
 #declare c=Data_Faces[i].z;
  #declare V1=Data_Vectors[a];
  #declare V2=Data_Vectors[b];
  #declare V3=Data_Vectors[c];
  #if(Cut=1)
   #if((V1.x>=Eps)&(V2.x>=Eps)&(V3.x>=Eps)) triangle{V1*Sc,V2*Sc,V3*Sc pigment{Gold}  rotate Rot} #end//dome
  #end
  #if(Cut=2)
   #if((V1.y>=Eps)&(V2.y>=Eps)&(V3.y>=Eps)) triangle{V1*Sc,V2*Sc,V3*Sc pigment{Gold}  rotate Rot} #end//dome
  #end
  #if(Cut=3)
   #if((V1.z>=Eps)&(V2.z>=Eps)&(V3.z>=Eps)) triangle{V1*Sc,V2*Sc,V3*Sc pigment{Gold}  rotate Rot} #end//dome
  #end
// triangle{V1*Sc,V2*Sc,V3*Sc pigment{Pink}  rotate Rot}
 //smooth_triangle{V1*Sc,V1,V2*Sc,V2,V3*Sc,V3 pigment{Gold} rotate y*0}
#end
