
//  display Array sizes for Save Data using GEODESIC.INC
// show the 3 symmetry values with 15 different freq values
//
// mode not used here as it deals with HOW the vectors are placed, NOT the number of vectors 
//
//  12:08:38 PM  Tuesday March 02,2021 
// Vers: 3.7
// Auth: Leroy Whetstone 
// Email whetstoneleroy@gmail.com 
// screen size 640*480

#version 3.7;
global_settings {assumed_gamma 1 max_trace_level 20}

//============ Change ========================================================

#declare Start=1;//>=1  values >209 will have funky a display

//====================================================================
#if(Start<1)   #declare Start=1; #end
#include "colors.inc"

camera{ location <0,0,-20>
        look_at <0,0,0>
        right x*image_width/image_height
        }
 light_source{<0,0,-10> color White parallel point_at 0}



text { ttf "arial.ttf", "Array sizes for SaveData.pov", 0.02, 0.0 // thickness, offset
       pigment{Orange}
       scale<1,1,1>
       translate<-7,8.5,0.00 >
      }


text { ttf "arial.ttf", "freq", 0.02, 0.0 // thickness, offset
       pigment{Red}
       scale<1,1,1>
       translate<-13,6,0.00 >
      }

text { ttf "arial.ttf", "symmetry=3", 0.02, 0.0 // thickness, offset
       pigment{Gold}
       scale<1,1,1>
       translate<-10,7,0.00 >
      }
text { ttf "arial.ttf", "symmetry=4", 0.02, 0.0 // thickness, offset
       pigment{Gold}
       scale<1,1,1>
       translate<-2.5,7,0.00 >
      }

text { ttf "arial.ttf", "symmetry=5", 0.02, 0.0 // thickness, offset
       pigment{Gold}
       scale<1,1,1>
       translate<6,7,0.00 >
      }

text { ttf "arial.ttf", "Vectors Faces Edges", 0.02, 0.0 // thickness, offset
       pigment{Pink}
       scale .75
       translate<-11,6,0.00 >
      }
text { ttf "arial.ttf", "Vectors Faces Edges", 0.02, 0.0 // thickness, offset
       pigment{Pink}
       scale .75
       translate<-3,6,0.00 >
      }
text { ttf "arial.ttf", "Vectors Faces Edges", 0.02, 0.0 // thickness, offset
       pigment{Pink}
       scale .75
       translate<5,6,0.00 >
      }

 cylinder{<-13,5.8,0><13,5.8,0>,.05 pigment{rgb.4}}
cylinder{<-11.2,6.8,0><-11.2,-9.2,0>,.05 pigment{rgb.4}}
cylinder{<-3.2,6.8,0><-3.2,-9.2,0>,.05 pigment{rgb.4}}
cylinder{<4.75,6.8,0><4.75,-9.2,0>,.05 pigment{rgb.4}}

#for(i,1,15)
 
 #declare j=Start+i-1;
 
 #declare q=j*j;

 #declare V1= 2*q+2; #declare F1= 4*q; #declare E1= 6*q;
 #declare V2= 4*q+2; #declare F2= 8*q; #declare E2= 4*q;
 #declare V3= 10*q+2; #declare F3= 20*q; #declare E3= 30*q;

 #declare Str1=concat(str(V1,0,0)," ",str(F1,0,0)," ",str(E1,0,0))
 #declare Str2=concat(str(V2,0,0)," ",str(F2,0,0)," ",str(E2,0,0))
 #declare Str3=concat(str(V3,0,0)," ",str(F3,0,0)," ",str(E3,0,0))

 cylinder{<-13,5.8-i,0><13,5.8-i,0>,.05 pigment{rgb.4}}

 text { ttf "arial.ttf", str(j,0,0), 0.02, 0.0 // thickness, offset
       pigment{Red}
       scale<1,1,1>
       translate<-12.75,6-i,0.00 >
      }

 text { ttf "arial.ttf", str(V1,0,0), 0.02, 0.0 // thickness, offset
       pigment{Green}
       scale .75
       translate<-11,6-i,0.00 >
      }
 text { ttf "arial.ttf", str(F1,0,0), 0.02, 0.0 // thickness, offset
       pigment{Green*.5}
       scale .75
       translate<-8.5,6-i,0.00 >
      }
 text { ttf "arial.ttf", str(E1,0,0), 0.02, 0.0 // thickness, offset
       pigment{Green}
       scale .75
       translate<-6,6-i,0.00 >
      }

  text { ttf "arial.ttf", str(V2,0,0), 0.02, 0.0 // thickness, offset
       pigment{Green}
       scale .75
       translate<-3,6-i,0.00 >
      }
  text { ttf "arial.ttf", str(F2,0,0), 0.02, 0.0 // thickness, offset
       pigment{Green*.5}
       scale .75
       translate<-.5,6-i,0.00 >
      }
  text { ttf "arial.ttf", str(E2,0,0), 0.02, 0.0 // thickness, offset
       pigment{Green}
       scale .75
       translate<2,6-i,0.00 >
      }


 text { ttf "arial.ttf", str(V3,0,0), 0.02, 0.0 // thickness, offset
       pigment{Green}
       scale .75
       translate<5,6-i,0.00 >
      }
 text { ttf "arial.ttf", str(F3,0,0), 0.02, 0.0 // thickness, offset
       pigment{Green*.5}
       scale .75
       translate<7.5,6-i,0.00 >
      }
 text { ttf "arial.ttf", str(E3,0,0), 0.02, 0.0 // thickness, offset
       pigment{Green}
       scale .75
       translate<10,6-i,0.00 >
      }
#end