//make data file
// Vers: 3.7
// Auth: Leroy Whetstone 
// Email whetstoneleroy@gmail.com
//====================================================================
#version 3.7;
global_settings {assumed_gamma 1 max_trace_level 20}

#include "colors.inc"
#include "geodesic.inc"

//-------------- Change ----------------------------------------------------------------------------  

  #declare symmetry     = 5;   // use octahedron
  #declare freq         = 2;   // subdivide faces into 5^2=25 triangles                       
  #declare mode         = 2;   // use spherical subdivision

  #declare FileName="TestData2.inc";
  #declare ArrayName="Pot"; //vertex_array's name
  #declare Remark="Fun time";

//--------------End of Change ----------------------------------------------------------------------------  

camera{ location <0,0,-10>
        look_at <0,0,0>
        right x*image_width/image_height
        }
 light_source{<0,10,0> color White parallel point_at 0}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color rgb <0.6,0.4,1>] [1.0 color blue 0.6] }
  }
}
   
#default{ texture{ finish  { ambient       .1
                             diffuse       .6
                             phong         .75
                             phong_size  50
                           } 
                 }   
        }                                  
        
//------------------------------------------------------------------------------------------  
//------------------------------------------------------------------------------------------  
 
//------------------------------------------------------------------------------------------  
// Let the game begin...
//
//
   
//  #include "LR_Mod_geodesic.inc"
  #include "geodesic.inc" 
  
//------------------------------------------------------------------------------------------  
                             

//---------------------Save it---------------------------------------------------------------------  
// calculate the vertex positions
/*
  #declare symmetry     = 5;   // use octahedron  3 4 5
  #declare freq         = 3;   // subdivide faces into 5^2=25 triangles                       
  #declare mode         = 1;   // use spherical subdivision
*/
  #declare vertex_array = geodesic(symmetry, freq, mode)  
  #declare Lt=dimension_size(vertex_array,1);
  #declare Lu=dimension_size(vertex_array,2);

  #declare C=0;
  #for(i,0,Lt-1)
   #for(j,0,Lu-1)
    #ifdef(vertex_array[i][j]) #declare C=C+1; #end
    #end
   #end
 #declare Mpnts=array[C];
  #declare D=0;
  #fopen Mfile FileName write
  #write(Mfile,FileName," = array[",C,"]{\n") 
  #for(i,0,Lt-1)
   #for(j,0,Lu-1)
    #ifdef(vertex_array[i][j]) 
      #declare Mpnts[D]=vertex_array[i][j];
      #if(D<C-1)#write(Mfile,Mpnts[D],",\n") 
      #else #write(Mfile,Mpnts[D],"\n") 
      #end
       //#if(C=2) #debug concat("I,J = ",str(i,0,0),",",str(j,0,0)"\n") #end
      #declare D=D+1; 
      sphere{vertex_array[i][j]*2,.1 pigment{rgb<1,0,0>}}
    //#else #debug concat("I,J = ",str(i,0,0),",",str(j,0,0)"\n")
    #end
   #end
  #end
  #write(Mfile,"}\n") 
  #fclose Mfile
  #debug concat("C =",str(C,0,0),"\n") 
  #debug concat("D =",str(D,0,0),"\n") 
  







//------------------------------------------------------------------------------------------  
// first definition block for the sub-macros:
//                          
//      small red spheres at the corners

  #macro do_corner(position)
    //sphere { position 0.003 texture { pigment { color rgb <1,0,0> } } }
  #end                                                          

//      blue cylinders at the edges ( between each pair of corners )
  
  #macro do_edge( corner_1, corner_2 )
  //  cylinder { corner_1, corner_2, 0.02 texture { pigment { color rgb <0,0,1> } } }
  #end

//      transparent, slightly greenish faces
  
  #macro do_face( corner_1, corner_2, corner_3 )
    //#if(mod(FC,2)) 
     triangle { corner_1, corner_2, corner_3 texture { pigment { color rgb <0.5,0.7,0.2> } } }
    //#end
    #declare FC=FC+1;
  #end

//------------------------------------------------------------------------------------------  

//------------------------------------------------------------------------------------------  
// let's get our first geodesic sphere
//      blow it up by a factor of two (i.e. the radius of the sphere will be 2 afterwards)
  #declare FC=0;                                                                                            
  object { geodesic_sphere ( symmetry, freq, vertex_array ) scale <2,2,2> }                                                                                               
  #debug concat("\nFC =",str(FC,0,0),"\n") 

//------------------------------------------------------------------------------------------  
  #declare i=(3*freq+1)*(5*freq);
  //#debug concat("I =",str(i,0,0),"\n") 
  //LR_Save_Pnts("TestData.inc")
  
  
  
  
  
  
  
  