// DO_Flowers.inc
// The following objects are defined in this file:
//    DO_Flower1, DO_Flower1L - small blue flower, height .3
//    DO_Flower2, DO_Flower2L - small white flower, height .3
//    DO_Flower3 - small orange flower, height .2
//    DO_Flower4 - bush with green leaves and yellow flowers, height .4, diameter .8
//    DO_Flower4X - bush like Flower4 with no flowers, just leaves
//    PatchOfWhiteFlowers - a patch of eight white flowers
//    PatchOfBlueFlowers - a patch of eight blue flowers

#ifndef (DO_FLOWERS_INC)
#declare DO_FLOWERS_INC = version
#version 3

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"

#declare R2 = seed(2)

// ========== Flower1 ========== //
// small white flower on stem with green leaves
// looks somewhat like a daisy
// height .3

#declare LeafTexture = texture {
   pigment { color rgb <.4,.6,.1> }
   }

#declare PetalTexture = texture {
   pigment { color rgb <1,1,.9> }
   }

#declare Leaf = difference {
   sphere { <0,0,0>, 1
      translate x*1 scale <.04,.01,.02>
      texture { LeafTexture }
      }
   sphere { <0,0,0>, 1
      translate x*1 translate y*-0.001 scale <.04,.01,.02>
      texture { LeafTexture }
      }
   }

#declare Height = .3
#declare YAngle = 0
#declare Stem = union {
   cylinder { <0,0,0>, <0,Height,0>, .006
      texture { LeafTexture }
      }
   #declare Num = 10
   #declare HeightInc = Height / (Num+1)
   #declare Y = HeightInc
   #while (Y < Height*.95)
      object { Leaf
         rotate z*(rand(R2)*30-15)
         translate y*Y
         rotate y*YAngle
         #declare Y = Y + HeightInc
         #declare YAngle = YAngle + 130 + rand(R2)*50
         }
   #end
   }

#declare Angle = 0
#declare YAngle = 0
#declare StemL = union {
   difference {
      torus { Height*2, .006 rotate x*90 }
      box { <-1,-1,-1>, <1,0,1> }
      box { <0,-1,-1>, <1,1,1> rotate z*60 }
      texture { LeafTexture }
      }
   #declare Num = 10
   #declare AngleInc = 30 / (Num+1)
   #declare Angle = AngleInc
   #while (Angle < 28)
      object { Leaf
         rotate y*YAngle
         translate x*(-Height*2)
         rotate z*(-Angle)
         #declare Angle = Angle + AngleInc
         #declare YAngle = YAngle + 130 + rand(R2)*50
         }
   #end
   translate x*Height*2
   }

#declare Petal = difference {
   sphere { <0,0,0>, 1
      translate x*1 scale <.05,.01,.03>
      }
   sphere { <0,0,0>, 1
      translate x*1 translate y*.001 scale <.05,.01,.03>
      }
   }

#declare Radius = .018

#declare Petals = union {
   sphere { <0,0,0>, Radius
      texture { pigment { color rgb <.7,.4,.3> } }
      scale <1,.3,1>
      }
   #declare Num = 8
   #declare Count = 0
   #declare Angle = 0
   #while (Angle < 360)
      object { Petal rotate z*20 translate x*Radius rotate y*Angle }
      #declare Angle = Angle + 360/Num
   #end
   }

#declare DO_Flower1 = union {
   object { Stem }
   object { Petals
       texture { PetalTexture }
       translate y*Height
       }
   }

#declare DO_Flower1L = union {
   object { StemL }
   object { Petals
      texture { PetalTexture }
      translate x*(-Height*2) rotate z*-30 translate x*Height*2
      }
   }

// ========== Flower2 ========== //
// similar to Flower1, with blue petals
// height .3

#declare PetalTexture = texture {
   pigment { color rgb <.4, .6, .8> }
   }

#declare DO_Flower2 = union {
   object { Stem }
   object { Petals
       texture { PetalTexture }
       translate y*Height
       }
   }

#declare DO_Flower2L = union {
   object { StemL }
   object { Petals
      texture { PetalTexture }
      translate x*(-Height*2) rotate z*-30 translate x*Height*2
      }
   }



// ========== Flower3 ========== //
// Small orange flower on stem with green leaves
// height 0.2

#declare Height = 0.2

#declare Leaf = difference {
   sphere { <0,0,0>, 1
      translate x*1 scale <.03,.01,.01>
      texture { pigment { color rgb <.4,.6,.1> } }
      }
   sphere { <0,0,0>, 1
      translate x*1 translate y*-0.001 scale <.03,.01,.01>
      texture { pigment { color rgb <.4,.6,.1> } }
      }
   rotate z*60
   }

#declare Stem = union {
   cylinder { <0,0,0>, <0,Height,0>, .005
      texture { pigment { color rgb <.3,.4,.2> } }
      }
   #declare Num = 6
   #declare HeightInc = Height / (Num+1)
   #declare Y = HeightInc
   #while (Y < Height*.95)
      object { Leaf
         rotate z*(rand(R2)*30-15)
         translate y*Y
         rotate y*YAngle
         #declare Y = Y + HeightInc
         #declare YAngle = YAngle + 130 + rand(R2)*50
         }
   #end
   }

#declare Petal = difference {
   sphere { <0,0,0>, 1
      translate x*1 scale <.07,.01,.03>
      }
   sphere { <0,0,0>, 1
      translate x*1 translate y*.001 scale <.07,.01,.03>
      }
   rotate z*50
   scale .5
   texture { pigment { color rgb <1,.4,0> } }
   }

#declare Petals = union {
   #declare Num = 6
   #declare Count = 0
   #declare Angle = 0
   #while (Angle < 360)
      object { Petal rotate z*20 rotate y*Angle }
      #declare Angle = Angle + 360/Num
   #end
   }

#declare DO_Flower3 = union {
   object { Stem }
   object { Petals translate y*Height }
   }

// ========== Flower4 ========== //
// a bush with green leaves and yellow flowers

// small green leaf
#declare Leaf = difference {
   sphere { <0,0,0>, 1
      translate x*1 scale <.04,.001,.01>
      texture { pigment { color rgb <.4,.6,.1> } }
      }
   sphere { <0,0,0>, 1
      translate x*1 translate y*-0.001 scale <.04,.001,.01>
      texture { pigment { color rgb <.4,.6,.1> } }
      }
   }

// Part1
// Some leaves on a stem, height .2
#declare Height = .2
#declare Tilt = 20
#declare Part1 = union {
   cylinder { <0,0,0>, <0,Height,0>, .006
      texture { pigment { color rgb <.5,.4,.3> } }
      }
   #declare Num = 6
   #declare Count = 0
   #while (Count < Num)
      object { Leaf
         rotate z*Tilt
         translate y*Height
         rotate y*360*Count/Num
         #declare Count = Count + 1
         }
   #end
   }

// yellow petals
#declare Petal = difference {
   sphere { <0,0,0>, 1
      translate x*1 scale <.04,.01,.02>
      }
   sphere { <0,0,0>, 1
      translate x*1 translate y*.001 scale <.04,.01,.02>
      }
   rotate z*25
   scale .75
   texture { pigment { color rgb <1,.8,.2> } }
   }

#declare Petals = union {
   #declare Num = 6
   #declare Count = 0
   #declare Angle = 0
   #while (Angle < 360)
      object { Petal rotate z*20 rotate y*Angle }
      #declare Angle = Angle + 360/Num
   #end
   }

// Part2
// 6 sets of leaves, plus one set with a flower
// height approximately .4
#declare Height = .2
#declare Num = 6
#declare Tilt = 40
#declare Part2 = union {
   #declare Count = 0
   #while (Count<Num)
      object { Part1 rotate y*10 rotate z*Tilt rotate y*360*Count/Num
         translate y*Height }
      #declare Count = Count + 1
   #end
   object { Part1 translate y*Height }
   cylinder { <0,2*Height,0>, <0,2*Height+.01,0>, .006
      texture { pigment { color <.4,.6,.1> } }
      }
   object { Petals translate y*(2*Height+.01) }
   cylinder { <0,0,0>, <0,Height,0>, .006
      texture { pigment { color rgb <.5,.4,.3> } }
      }
   }

// 6 sets of leaves with no flower
#declare Height = .2
#declare Num = 6
#declare Tilt = 40
#declare Part2X = union {
   #declare Count = 0
   #while (Count<Num)
      object { Part1 rotate y*10 rotate z*Tilt rotate y*360*Count/Num
         translate y*Height }
      #declare Count = Count + 1
   #end
   object { Part1 translate y*Height }
   cylinder { <0,0,0>, <0,Height,0>, .006
      texture { pigment { color rgb <.5,.4,.3> } }
      }
   }

// Flower4
// round bush with green leaves and yellow flowers
// height approximately .4
// width approximately .8
#declare Num = 6
#declare Tilt = 40
#declare DO_Flower4 = union {
   #declare Count = 0
   #while (Count<Num)
      object { Part2 rotate y*10 rotate z*Tilt rotate y*360*Count/Num }
      #declare Count = Count + 1
   #end
   object { Part2 }
   }

// Flower4X
// round bush with green leaves and no flowers
// height approximately .4
// width approximately .8
#declare Num = 6
#declare Tilt = 40
#declare DO_Flower4X = union {
   #declare Count = 0
   #while (Count<Num)
      object { Part2X rotate y*10 rotate z*Tilt rotate y*360*Count/Num }
      #declare Count = Count + 1
   #end
   object { Part2X }
   }

// Eight white flowers
#declare PatchOfWhiteFlowers = union {
   object { DO_Flower1  scale 1.00 rotate y*090 translate <-0.25,0,-0.05> }
   object { DO_Flower1L scale 0.90 rotate y*170 translate <-0.20,0,-0.25> }
   object { DO_Flower1  scale 1.40 rotate y*040 translate <-0.15,0, 0.20> }
   object { DO_Flower1L scale 0.90 rotate y*090 translate < 0.00,0, 0.05> }
   object { DO_Flower1  scale 0.60 rotate y*090 translate < 0.20,0,-0.20> }
   object { DO_Flower1L scale 0.90 rotate y*050 translate < 0.00,0,-0.25> }
   object { DO_Flower1  scale 1.20 rotate y*040 translate < 0.15,0, 0.15> }
   object { DO_Flower1L scale 0.60 rotate y*010 translate < 0.25,0, 0.00> }
   }

// Eight blue flowers
#declare PatchOfBlueFlowers = union {
   object { DO_Flower2  scale 1.10 rotate y*090 translate <-0.25,0,-0.05> }
   object { DO_Flower2L scale 0.90 rotate y*170 translate <-0.20,0,-0.25> }
   object { DO_Flower2  scale 1.30 rotate y*040 translate <-0.15,0, 0.20> }
   object { DO_Flower2L scale 0.90 rotate y*090 translate < 0.00,0, 0.05> }
   object { DO_Flower2  scale 0.70 rotate y*090 translate < 0.20,0,-0.20> }
   object { DO_Flower2L scale 0.90 rotate y*050 translate < 0.00,0,-0.25> }
   object { DO_Flower2  scale 1.20 rotate y*040 translate < 0.15,0, 0.15> }
   object { DO_Flower2L scale 0.80 rotate y*010 translate < 0.25,0, 0.00> }
   }

// uncomment a section below to render an image of the flowers

/*
// A patch of eight white flowers
camera { location <0,.8,-1.2> look_at <0,.2,0> }
light_source { <-20,10,-20> color rgb <1,1,1> }
light_source { <10,12,-20> color rgb <1,1,1> }
plane {  y,  0 texture { pigment { color <.7,.7,.7> } } }
plane {  x, -5 texture { pigment { color <.7,.7,.7> } } rotate y*35 }
plane { -z, -5 texture { pigment { color <.7,.7,.7> } } rotate y*35 }
torus { 0.5, 0.05 texture { T_Stone13 } }
cylinder { <0,0,0>, <0,.01,0>, 0.51 texture { pigment { color rgb <0,0,0> } } }
object { PatchOfWhiteFlowers translate <0,0,0> }
*/

/*
// A patch of eight blue flowers
camera { location <0,.8,-1.2> look_at <0,.2,0> }
light_source { <-20,10,-20> color rgb <1,1,1> }
light_source { <10,12,-20> color rgb <1,1,1> }
plane {  y,  0 texture { pigment { color <.7,.7,.7> } } }
plane {  x, -5 texture { pigment { color <.7,.7,.7> } } rotate y*35 }
plane { -z, -5 texture { pigment { color <.7,.7,.7> } } rotate y*35 }
torus { 0.5, 0.05 texture { T_Stone13 } }
cylinder { <0,0,0>, <0,.01,0>, 0.51 texture { pigment { color rgb <0,0,0> } } }
object { PatchOfBlueFlowers translate <0,0,0> }
*/

/*
// several Flower3
camera { location <0,.8,-1.2> look_at <0,.2,0> }
light_source { <-20,10,-20> color rgb <1,1,1> }
light_source { <10,12,-20> color rgb <1,1,1> }
plane {  y,  0 texture { pigment { color <.7,.7,.7> } } }
plane {  x, -5 texture { pigment { color <.7,.7,.7> } } rotate y*35 }
plane { -z, -5 texture { pigment { color <.7,.7,.7> } } rotate y*35 }
torus { 0.5, 0.05 texture { T_Stone13 } }
cylinder { <0,0,0>, <0,.01,0>, 0.51 texture { pigment { color rgb <0,0,0> } } }
#declare R1 = seed(0)
#declare Num = 15
#declare Angle = 0
#declare AngleInc = 360/Num
#while (Angle < 359)
   object { DO_Flower3 scale rand(R1)*.5+.75 translate z*(.2+rand(R1)*.2) rotate y*Angle }
   #declare Angle = Angle + AngleInc
#end
*/

/*
// Flower4
camera { location <0,.8,-1.2> look_at <0,.2,0> }
light_source { <-20,10,-20> color rgb <1,1,1> }
light_source { <10,12,-20> color rgb <1,1,1> }
plane {  y,  0 texture { pigment { color <.7,.7,.7> } } }
plane {  x, -5 texture { pigment { color <.7,.7,.7> } } rotate y*35 }
plane { -z, -5 texture { pigment { color <.7,.7,.7> } } rotate y*35 }
torus { 0.5, 0.05 texture { T_Stone13 } }
cylinder { <0,0,0>, <0,.01,0>, 0.51 texture { pigment { color rgb <0,0,0> } } }
object { DO_Flower4 rotate y*20 translate <0,0,0> }
*/

/*
// Flower4X
camera { location <0,.8,-1.2> look_at <0,.2,0> }
light_source { <-20,10,-20> color rgb <1,1,1> }
light_source { <10,12,-20> color rgb <1,1,1> }
plane {  y,  0 texture { pigment { color <.7,.7,.7> } } }
plane {  x, -5 texture { pigment { color <.7,.7,.7> } } rotate y*35 }
plane { -z, -5 texture { pigment { color <.7,.7,.7> } } rotate y*35 }
torus { 0.5, 0.05 texture { T_Stone13 } }
cylinder { <0,0,0>, <0,.01,0>, 0.51 texture { pigment { color rgb <0,0,0> } } }
object { DO_Flower4X rotate y*25 translate <0,0,0> }
*/

#version DO_FLOWERS_INC
#end
