// c2s3_bld.inc -- macros to build various screen-level objects
#ifndef(C2S3_BLD_INC)
#declare C2S3_BLD_INC=true;

#macro c2s3_BuildMesh()
//  #local cFB=0;
  mesh {
  #local iR=0;
  #local iRU=0; #local cU=0;
  #local iF=0; #while(iF<c2s3cF)
    #local cV=c2s3aFV[iR]; #local iR=iR+1;
    #local pC=c2s3aV[c2s3aFV[iR]];
    #ifdef(c2s3aFN)
      #local nC=c2s3aN[c2s3aFN[iR]];
    #end
    #ifdef(c2s3aFU)
      #local cU=c2s3aFU[iRU];
      #local iRU=iRU+1;
    #end

    #local iI=1;#while(iI<cV-1)
      #ifdef(c2s3aFN)
        smooth_triangle {
          pC,nC,
          c2s3aV[c2s3aFV[iR+iI]],
          c2s3aN[c2s3aFN[iR+iI]],
          c2s3aV[c2s3aFV[iR+iI+1]],
          c2s3aN[c2s3aFN[iR+iI+1]]
      #else
        triangle { pC,c2s3aV[c2s3aFV[iR+iI]],c2s3aV[c2s3aFV[iR+iI+1]]
      #end
      #if(cU>0)
        uv_vectors
          c2s3aU[c2s3aFU[iRU]],
          c2s3aU[c2s3aFU[iRU+iI]],
          c2s3aU[c2s3aFU[iRU+iI+1]]
      #end
        }
    #local iI=iI+1;#end
    #local iR=iR+cV;
    #local iRU=iRU+cU;
  #local iF=iF+1;#end
  }
//  #debug concat("Faces rendered: ",str(cFB,0,0),"\n")
#end // end of macro

#macro c2s3_BuildTexturedMesh(aiT)
//  #local cFB=0;

#ifndef(c2s3aFT)
  c2s3_BuildMesh()
#else

  mesh {
  #local iR=0;
  #local iRU=0; #local cU=0;
  #local iF=0; #while(iF<c2s3cF)
    #local iT=c2s3aFT[iF];
    #local cV=c2s3aFV[iR]; #local iR=iR+1;
    #local pC=c2s3aV[c2s3aFV[iR]];
    #ifdef(c2s3aFN)
      #local nC=c2s3aN[c2s3aFN[iR]];
    #end
    #ifdef(c2s3aFU)
      #local cU=c2s3aFU[iRU];
      #local iRU=iRU+1;
    #end

    #local iI=1;#while(iI<cV-1)
      #ifdef(c2s3aFN)
        smooth_triangle { pC,nC,
        c2s3aV[c2s3aFV[iR+iI]],
        c2s3aN[c2s3aFN[iR+iI]],
        c2s3aV[c2s3aFV[iR+iI+1]],
        c2s3aN[c2s3aFN[iR+iI+1]]
      #else
      triangle {
        pC,c2s3aV[c2s3aFV[iR+iI]],c2s3aV[c2s3aFV[iR+iI+1]]
      #end
      #if(cU>0)
        uv_vectors
          c2s3aU[c2s3aFU[iRU]],
          c2s3aU[c2s3aFU[iRU+iI]],
          c2s3aU[c2s3aFU[iRU+iI+1]]
      #end
      #if(iT>-1) texture { aiT[iT] } #end
      }
    #local iI=iI+1;#end
    #local iR=iR+cV;
    #local iRU=iRU+cU;
  #local iF=iF+1;#end
  }
//  #debug concat("Faces rendered: ",str(cFB,0,0),"\n")
#end // end of ifndef() block
#end // end of macro

#macro c2s3_BuildFrame(rRadius,iColor,colColor)
  #ifndef(c2s3cE) c2s3_BuildEdges() #end
  #local iE=0;#while(iE<c2s3cE)
    cylinder { c2s3aV[c2s3aEA[iE]],c2s3aV[c2s3aEB[iE]],rRadius
      #if(iColor=iE) pigment { colColor } #end
    }
  #local iE=iE+1;#end
#end

#macro c2s3_Porcupine(iColor,colColor)
  #local iR=0;
  #local iF=0;#while(iF<c2s3cF)
    #local cV=c2s3aFV[iR]; #local iR=iR+1;
    #local vX=<0,0,0>;
    #local vY=<0,0,0>;
    #local pC=<0,0,0>;
    #local iI=0;#while(iI<cV)
      #local pV=c2s3aV[c2s3aFV[iR+iI]];
      #local vX=vX+pV*cos(2*pi*iI/cV);
      #local vY=vY+pV*sin(2*pi*iI/cV);
      #local pC=pC+pV;
    #local iI=iI+1;#end
    #local pC=pC/cV;
    #local vN=vcross(vX,vY);
    #local sL=sqrt(vlength(vN))/cV;
    cone { pC,sL*.25,pC+vnormalize(vN),0
    #if(iF=iColor)
      pigment { rgb colCOlor }
    #end
    }
    #local iR=iR+cV;
  #local iF=iF+1;#end
#end

#end // end of #ifndef(C2S3_BLD_INC) block
