
//*********************************************************************************
// SmokeGen parameter file for SplFile.pov
//*********************************************************************************
#include "SGMacros.inc"
#include "Winds.inc" 
//*********************************************************************************

// Convenient, as both the SplPosOf() macro and SplineFile use the same file:
#local spl_file_used="Path.spl" 

// BASIC
// retrive spline_pos using the SplPos function macro
#declare obj_pos=SplPosOf(spl_file_used,clock);
#declare TraceLevel=100;
#declare Debugging=1;

#declare SceneStartClock=0.2;
#declare PreviewMode=2;
#declare MainColor=<1,1,1>;

// TIME SIM
#declare SplineFile=spl_file_used
#declare SplineClockStart=0;
#declare SplineClockStop=SceneStartClock;
#declare FramesElapsed=10;

// TRAIL SPECIFIC
#declare SmokeDelay=2;

// SIZE SPECIFIC
#declare InitialSize=3;
#declare MaxSizeInc=0.5;		
#declare MaxFinalSize=5.0;      

// EMISSION SPECIFIC
#declare InitEmiss=1.5;			    
#declare MinEmiss=0.1;		
#declare MaxEmiss=3.5;
#declare Trend=-0.06;

// APPEARANCE SPECIFIC
#declare Roughness=1;
#declare StartTurb=3.5;
#declare TurbIncRate=0.03;
#declare CastShadows=1;

// WIND, ROTATION & ASCENSION
#declare ConstAscendRate=0.02;
#declare MaxRandAscend=0.0;	
#declare WindDir=S;
#declare WindStrength=0.03;