// *************************************************************************************************
// *************************************************************************************************
//
// AutoFly version 1.1 by Mikael Carneholm 
// April 1999
// 
// *************************************************************************************************
// *************************************************************************************************  
// SEE AUTOFLY.TXT FOR INSTRUCTIONS      

#ifndef(AutoFly_Included)
#	declare AutoFly_Included=true;

#ifdef(View_POV_Include_Stack)
#   debug "including autofly.inc\n"
#end

#ifndef(BankLimit)
  #declare BankLimit=90;
#end

#macro GetSplinePos(ClockValue, SplineFile)
	#declare spline_clock=ClockValue;
	#include Splinefile
	(spline_pos) //return spline_pos
#end

#macro AutoFly(Splinefile,origin,ahead_turning,ahead_banking,bank_strength,auto)
	#local vCurrentSplinePos=GetSplinePos(origin, Splinefile);	
	#local vFutureSplinePos=GetSplinePos(origin+ahead_turning, Splinefile);
	#local dX1=vFutureSplinePos.x-vCurrentSplinePos.x;
	#local dY1=vFutureSplinePos.y-vCurrentSplinePos.y;
	#local dZ1=vFutureSplinePos.z-vCurrentSplinePos.z;
	
	//************************************************************************
	// Rotation about the Z-axis (up/down)	 

	#declare ZRot=(atan2(dY1,abs(dX1+dZ1))*180/pi);	
  
	//************************************************************************
	// Rotation about the Y-axis (left/right)

	#declare YRot=-(atan2(dZ1,dX1)*180/pi);	
	
	//************************************************************************
	// Rotation about the X-axis (banking)	
	
	#local vFutureSplinePos2=GetSplinePos(origin+ahead_turning+ahead_banking, Splinefile);
	#local dX2=vFutureSplinePos2.x-vFutureSplinePos.x;	
	#local dZ2=vFutureSplinePos2.z-vFutureSplinePos.z;
	#declare YRot_future=-(atan2(dZ2,dX2)*180/pi);  
	//calculate the delta rotation:
	#local dYRot=YRot_future-YRot;
	
	#if (dYRot>180 | dYRot<-180)
		#if(dYRot<-180)
			#local dYRot=dYRot+360;
		#else
			#local dYRot=dYRot-360;
		#end
	#end	

	#declare XRot= -dYRot*bank_strength;

	// Limit the banking
	#if(XRot>90)
		#declare XRot=BankLimit; 
	#end
	
	#if(XRot<-90)
		#declare XRot=-BankLimit; 
	#end
		
	//***********************************************************	   
	// Rotate and translate the object if auto=true
	
	#if(auto)
		rotate<XRot,0,0> // banking
		rotate<0,0,ZRot> // up/down		
		rotate<0,YRot,0> // left/right
		translate vCurrentSplinePos
	#end

#end // macro


#end // ifndef
// *************************************************************************************************
// EOF