// LnsFlare 3.0 demonstration file for POV-Ray 3.0
//
// By Nathan Kopp - December 26, 1997
//

#declare sky_vect = z
#declare cam_loc = <0,0,0>
#declare lookat = <0,5,0>
#declare light_loc = <-2,5,1.5>

camera {  //  Camera StdCam
  location  cam_loc
  direction <0.0,     0.0,  1.04>
  sky       sky_vect   // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   lookat
}

#declare flare_scale_factor = 1
#declare flare_amount = 1
#declare spot_fade_amount = .01
#declare flare_type = "space3"    //  <- Change this value!
#include "lnsflare.inc"


background { color <0.000,0.000,0.000> }

// *******  L I G H T S *******
light_source {   // Light1
  <0.376, -6.266, 10.316>
  color rgb <1.000, 1.000, 1.000>
}

// ********  OBJECTS  *******

sphere {
   <0,0,0>, 1
   pigment {
      bozo
      colour_map {
         [.7   colour rgb <0, .11, .67>   ]
         [.7   colour rgb <0, .4, 0>      ]
         [.999 colour rgb <.4, .53, .0>   ]
         [1.01 colour rgb <.53, .11, .11> ]
         }
      turbulence .5
      scale 1/3
      translate 100*x
      }
   scale 2
   translate <0,5,0>
   }

sphere {
   <0,0,0>, 1
   pigment {
      bozo
      colour_map { [0 colour rgbf 1]
                   [.4 colour rgbf 1]
                   [.9 colour rgb 1 ] }
      turbulence 1.0
      scale <12/30, 3/30, 12/30>
      rotate <30, 0, -45>
      }
   scale 2.05
   translate <0,5,0>
   }


