// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

#version 3.1

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <0.0, 2.5, -0.0>
  look_at   <0.0, 0.0,  0.0>
}


light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}

// uses image color index as height, extends along X-Z axes
// from <0 0 0> to <1 1 1>
object {
height_field
{
  tga               // the file type to read (gif/tga/pot/pgm/ppm/png/sys)
  "look.tga"     // the file name to read
  //inverse
//  [smooth]        // make smoother surface
  water_level 0.7 // truncate/clip below N (0.0 ... 1.0)
  translate <-1.0,0.0,-1.0>
}
pigment { Blue * 0.6 + White*0.1}
}