alias goDEMs3 {
  ; 30-meter with 7z.exe 7z.dll in folder or path
  ; http://www.webgis.com/terr_pages/AZ/dem1/coconino.html
  %WorkingDir = c:\ftp\dempov\bin
  ; New instructions
  ; Set %WorkingDir - download zips -- no pasting html to dems.txt
  ; /unzipall   ... make unzip.txt - open and check it. resave as .bat
  ; unzip_bat   ... same-name files exist! a(u)to rename to keep all: u
  ; set in dems_batch -- %parameters = 0 0 5 0 0
  ; /dems_batch ... make rename.txt - open and check it. resave as .bat
  ; rename_bat  ... rename DEM files
  ; /dems_batch ... make dem2tga.txt, with renamed DEM files, for tga files
  ; dem2tga_bat ... DEMPOV nelson.dem nelson.tga 0 0 5 0 0
  demHeadRead
  demsort
}
alias deminit {
  %parameters = 0 0 15 0
  %WorkingDir = c:\ftp\dempov\bin
  %proj = untitled
  ; if (!init) program uses defaults
}
menu status {
  -
  DEM Commands
  .DEM Initialize: deminit
  .Make unzipbat.txt: unzipall
  .DEMPOV Batch Files: dems_batch
  .Read DEM Headers: demHeadRead
  .Sort DEMs: demsort
}
alias ParametersAre {
  if (4parameters) bias = -min_elevation
  0 all
  0 or 1 normalize
  1 verticalScale
  [ bias ] optional
  0 default elevation/edge stuff ?
}
alias dems_batch {
  if (%WorkingDir == $null) {
    %WorkingDir = $mircdir | WorkingDir was null. Set to mircdir.
  }
  if (%proj == $null) %proj = untitled

  var %d = %WorkingDir, %renf = $+(%d,\,%proj,_rename.txt)
  var %wf = $+(%d,\,%proj,_dem2tga.pov)
  var %nf = $findfile(%d,*.dem,0,1), %i = 1
  if (%nf) {
    write -c %wf | write -c %renf
    write %wf path $+($chr(37),PATH,$chr(37),$chr(59), %d)
    ; e %wf path $+($chr(37),PATH,$chr(37),$chr(59), %d)
    while (%i <= %nf) {
      batmaketxt %i
      inc %i
    }
    e saved to %renf
    e saved to %wf
  } 
  else e %nf Digital Elevations Models found
}
alias batmaketxt {
  var %d = %WorkingDir, %renf = $+(%d,\,%proj,_rename.txt)
  var %wf = $+(%d,\,%proj,_dem2tga.pov)
  var %i = $1
  var %t, %r, %f = $findfile(%d,*.dem,%i,1)
  if ($fopen(ofile)) .fclose ofile
  .fopen ofile %f
  %r = $left($fread(ofile),940)
  %r = $formatname(%r)
  .fclose ofile
  %t = %r $+ .tga
  %r = %r $+ .dem
  if ($nopath(%f) != %r) {
    ; e Renaming %f $+($nofile(%f),%r)
    write %renf ren %f %r
  }
  if (%parameters == $null) %parameters = 0 0 15 0
  write %wf DEMPOV %r %t %parameters
}

; Digital Elevation Model - sort position
alias demsort {
  var %f = demsformat.txt
  var %n = $lines(%f), %n2
  if (%n < 2) { e nothing to sort, %n DEMS - halting | halt }
  if (!$window(@sort)) window -dlks @sort $calc($window(-3).w - 540) 10 500 $window(-3).h
  if (!$window(@sort2)) window -dlks @sort2 $calc($window(-3).w - 500) 10 500 $window(-3).h
  %n2 = $line(@sort,0)
  dline @sort 1- %n2
  %n2 = $line(@sort2,0)
  dline @sort2 1- %n2
  clear -s

  var %i = 1, %line
  var %j = 1, %r, %minlon = 9000000, %minlat = 9000000

  ; /////////// location vars //////////////// start xz at 0
  var %min_lat = 42.998056
  var %min_lon = 78.5
  ; abs(longitude) backwards for East Lon. $degreeslat()
  ; how many divisions of one degree - for xz place ints
  var %Xmult = 9
  var %Ymult = 8
  ; auto set: %min_lat %min_lon
  ; EAST/WEST %x * -1 for South Lat, %y * -1 for East Lon
  ; //////////////////////////////////////////

  while (%i <= %n) {
    %r = $read(%f,%i)
    %line = $gettok(%r,2-,32) $gettok(%r,1,32)
    aline -n @sort %line
    ; $ifmatch failed to set
    if (%minlat > $degreeslat($gettok(%line,3,32))) %minlat = $degreeslat($gettok(%line,3,32))
    if (%minlon > $degreeslat($gettok(%line,1,32))) %minlon = $degreeslat($gettok(%line,1,32))
    inc %i
  }
  ; AUTO NAME PROJECT
  if ((%proj == $null) || (%proj == untitled)) {
    %line = $line(@sort,1)
    %proj = $gettok(%line,5,32)
  }
  %min_lat = %minlat
  %min_lon = %minlon
  %i = 1
  %n = $line(@sort,0)
  var %start = $gettok($line(@sort,1),1,32)
  var %x, %y, %lat, %lon
  e #local n = .988;
  while (%i <= %n) {
    %line = $line(@sort,%i)

    if (%start == $gettok(%line,1,32)) {
      aline -n @sort2 $gettok(%line,3-,32) $gettok(%line,1-2,32)
      %lon = $degreeslat($gettok(%line,1,32))
      %y = $int($calc((%lon - %min_lon) * %Ymult))
      if ($gettok(%line,1,176) > 0) %y = $calc(%y * -1)
      ; -1 for East Lon
      if ((%i == 1) && (%y)) echo -s DIDN'T START 0 !! - set abs min_lon min_lat to start at 0
    }
    else {
      %start = %line 
      %j = 1
      %n2 = $line(@sort2,0)

      while (%j <= %n2) {
        %line = $line(@sort2,%j)
        %lat = $degreeslat($gettok(%line,1,32))
        %x = $int($calc((%lat - %min_lat) * %Xmult))
        if ($gettok(%line,1,176) < 0) %x = $calc(%x * -1)
        ; -1 for South Lat
        e pce( $+(", $gettok(%line,3,32), .tga") , %x *n, %y *n,0)
        inc %j
      }
      dline @sort2 1- %n2
      aline -n @sort2 $gettok(%start,3-,32) $gettok(%start,1-2,32)
      %start = $gettok(%start,1,32)
    }
    inc %i
  }
  %j = 1
  %x = 0
  %n2 = $line(@sort2,0)
  while (%j <= %n2) {
    %line = $line(@sort2,%j)
    %lat = $degreeslat($gettok(%line,1,32))
    %x = $int($calc((%lat - %min_lat) * %Xmult))
    if ($gettok(%line,1,176) < 0) %x = $calc(%x * -1)
    ; -1 for South Lat
    e pce( $+(", $gettok(%line,3,32), .tga") , %x *n, %y *n,0)
    inc %x
    inc %j
  }
  dline @sort2 1- %n2
  if (%WorkingDir == $null) {
    %WorkingDir = $mircdir | WorkingDir was null. Set to mircdir.
  }
  savebuf -s %WorkingDir $+ \sortpov.pov
  e saved to $+(%WorkingDir,\,%proj,_sort.pov)
}

alias degreeslat {
  var %n = $replace($1,,$chr(32))
  %n = $replace(%n,',$chr(32))
  return $calc($abs($gettok(%n,1,32)) + $gettok(%n,2,32) / 60 + $gettok(%n,3,32) / 60 / 60)
}

alias unzipall {
  if (%WorkingDir == $null) {
    %WorkingDir = $mircdir | WorkingDir was null. Set to mircdir.
  }
  if (%proj == $null) %proj = untitled
  var %d = %WorkingDir, %wf = $+(%d,\,%proj,_unzip.txt)
  var %nf = $findfile(%d,*.zip,0,1,e $1)
  var %i
  if (%nf) {
    write -c %wf
    write %wf REM path $+($chr(37),PATH,$chr(37),$chr(59), %d)
    e %wf path $+($chr(37),PATH,$chr(37),$chr(59), %d)
    %i = 1
    while (%i <= %nf) {
      zzzip %i
      inc %i
    }
  }
  ; ren %WorkingDir $+ \*.dem a*
  ; REM 7z a archive.zip %WorkingDir $+ \* -aoa -y -sdel
  e saved to %wf
}

alias zzzip {
  var %d = %WorkingDir, %wf = $+(%d,\,%proj,_unzip.txt)
  var %i = $1
  var %df, %r, %f = $findfile(%d,*.zip,%i,1)
  write %wf 7z x %f
}

alias -l e echo -s $1-

alias DemRead {
  var %d = %WorkingDir, %r
  var %f = %d $+ \gasport.dem
  if ($1 isnum) %f = $findfile(%d,*.dem,$1,1)
  if ($fopen(ofile)) .fclose ofile
  .fopen ofile %f
  %r = $left($fread(ofile),940)
  .fclose ofile
  return $formatname(%r) $lonlatv(%r)
}

alias formatname {
  var %r = $1
  ; might be comma, might be hyphen , -
  %r = $gettok(%r,1,44)
  %r = $gettok(%r,1,45)
  %r = $replace(%r,mountain,mtn)
  %r = $remove(%r,$chr(32))
  %r = $lower($remove(%r,'))
  return %r
}
alias lonlatv {
  var %r = $1, %a, %b, %c, %lat, %lon
  ; %r = GASPORT, NY-24000 LAT:: 43 7 30.0000 N LONG:: -78 30 0.0000 W SCALE:: 24000
  var %t = $findtok(%r,LAT::,1,32)
  inc %t
  %a = $gettok(%r,%t,32)
  inc %t
  %b = $gettok(%r,%t,32)
  inc %t
  %c = $gettok(%r,%t,32)
  if (%a isnum -90-90) %lat = %a
  if (%b isnum 0-60) %lat = $+(%lat,$chr(176),%b)
  if (%c isnum 0.0-60.0) %lat = $+(%lat,', %c)

  %t = $findtok(%r,LONG::,1,32)
  inc %t
  %a = $gettok(%r,%t,32)
  inc %t
  %b = $gettok(%r,%t,32)
  inc %t
  %c = $gettok(%r,%t,32)
  if (%a isnum -180-180) %lon = %a
  if (%b isnum 0-60) %lon = $+(%lon,$chr(176),%b)
  if (%c isnum 0.0-60.0) %lon = $+(%lon,', %c)

  if ((!%lat) && (!%lon)) return 0 0 0 0
  return %lon 0 %lat 0

  if (%lat) %lat = $degreeslat(%lat)
  else echo -s Latitude Not Found
  if (%lon) %lon = $degreeslat(%lon)
  else echo -s Longitude Not Found
}
alias demHeadRead {
  if (%WorkingDir == $null) {
    %WorkingDir = $mircdir | WorkingDir was null. Set to mircdir.
  }
  var %i = 1, %wf = demsformat.txt, %dr
  write -c %wf
  var %nf = $findfile(%WorkingDir,*.dem,0,1,e $1)
  ; var %nf = $findfile(%WorkingDir,*.dem,0,1)
  if (%nf) {
    while (%i <= %nf) {
      %dr = $DemRead(%i)
      write %wf %dr
      e %dr
      inc %i
    }
    e saved to %wf - required file to sort
  }
  else e %nf Digital Elevations Models found
}

alias testc {
  var %y = 2
  %y = %y * 3
  e %y
}
