/****************************************************************************
**                    Campionamento per un diaframma                       **
****************************************************************************/
#if (gShapeDepth)
	#macro RecBuildDataDiaframma(S0, S1, Depth)
		#local SMid = (S0+S1)/2;
		#local F1 = EvalCubic(Sect[J],S1); 
		#local Err = vlength(EvalCubic(Sect[J],SMid) - (aSmpPos[Pos-1]+F1)/2);
		#if (Depth & Err >= gShapeErr)
			RecBuildDataDiaframma(S0, SMid, Depth-1)
			RecBuildDataDiaframma(SMid, S1, Depth-1)
		#else
			#declare aSmpPos[Pos] = F1;
			#declare aSmpDer[Pos] =EvalCubicDer(Sect[J],S1);
			#declare Pos = Pos + 1;
		#end
	#end
	
	#macro DiafSamples()
		#local Size = (gShapeDiv * pow(2,gShapeDepth+1) + 1) * gNumShapeSegments;
		#declare aSmpPos = array[Size]
	   #declare aSmpDer = array[Size]
	   
		// campionamento dei punti: passo fisso
		#local J=0;
		#local Pos = 1;
		#declare aSmpPos[0] = EvalCubic(Sect[J],0);
		#declare aSmpDer[0] = EvalCubicDer(Sect[J],0);
		#while (J<gNumShapeSegments)
			#local I=0;
			#while (I < gShapeDiv)
				RecBuildDataDiaframma(I/gShapeDiv, (I+1)/gShapeDiv, gShapeDepth)
				#local I=I+1;
			#end
			#local J=J+1;
		#end
		#local I = 0;
		#declare aSmpPos = aCrop(aSmpPos,Pos)
		#declare aSmpDer = aCrop(aSmpDer,Pos)
	#end
#else
	#macro DiafSamples()
		#declare aSmpPos = array[gNumShapeSegments * gShapeDiv + 1]
		#declare aSmpDer = array[gNumShapeSegments * gShapeDiv + 1]
		#declare aSmpPos[0] = EvalCubic(Sect[0], 0);
		#declare aSmpDer[0] = EvalCubicDer(Sect[0], 0);
		#local J=0;
		#while (J<gNumShapeSegments)
			#local I=1;
			#while (I <= gShapeDiv)
				#declare aSmpPos[I+J*gShapeDiv] = EvalCubic(Sect[J],I/gShapeDiv);
				#declare aSmpDer[I+J*gShapeDiv] = EvalCubicDer(Sect[J],I/gShapeDiv);
				#local I=I+1;
			#end
			#local J=J+1;
		#end
	#end
#end

/****************************************************************************
**               Costruzione di una sezione di superficie                  **
****************************************************************************/
// Una sola sezione
#ifdef (gsplShape)
	#macro splBuildSection(T)
		#local X = CalcChordAbscissa(gsltPath, T);
		#local B = bBuildBase(T, X)
		splMatrixSpline(gsplShape, B)
	#end

// Piu' sezioni diverse
#else
	#macro splBuildSection(T) 
		#local X = CalcChordAbscissa(gsltPath, T);
		#local Weight = GetMorph(X);
		#local nShape = GetSplineIndex(gsllShapes, X);
		#local Shape1 = splGetSpline(gsllShapes, int(nShape))
		#local Shape2 = splGetSpline(gsllShapes, int(nShape)+1)
		#local Section = splAverageSplines(Shape1, Shape2, Weight)
		#local B = bBuildBase(T, X)
		#local Section = splMatrixSpline(Section, B)
		Section
	#end
#end

/****************************************************************************
**                  Marcatori di inizio e fine oggetto                     **
****************************************************************************/
// Comincia l'oggetto
#ifdef(gsBufferName)
	#macro BeginSurface()
		#switch(gObjectType)
			#case (UNION) #write (fbfBufferStriscia, "union {\n") #break
			#case (MESH)  #write (fbfBufferStriscia, "mesh {\n") #break
		#end
	#end
	
	// Termina l'oggetto
	#macro EndSurface()
		#switch(gObjectType)
			#case (UNION)
			#case (MESH) #write (fbfBufferStriscia, "}\n") #break
		#end
	#end
#else
	#macro BeginSurface()
		#switch(gObjectType)
			#case (UNION) union { #break
			#case (MESH)  mesh  { #break
		#end
	#end
	
	// Termina l'oggetto
	#macro EndSurface()
		#switch(gObjectType)
			#case (MESH)
			#case (UNION) } #break
		#end
	#end
#end

/****************************************************************************
**              Disegno dei triangoli col texture mapping.                 **
**                           versione adattiva                             **
****************************************************************************/
#ifdef(gtxtWrapped)
	#if (gShapeDepth)
   	// campionamento dei punti e delle normali: passo induttivo
   	#declare END_MARK = 1e+8;
   	#macro RecBuildData(S0, S1, Depth)
			#local SMid = (S0+S1)/2;
			#local F1 = EvalCubic(Sect[J],S1);
			#local Err = vlength(EvalCubic(Sect[J],SMid) - (smpSect[Slot][J][Pos-1]+F1)/2);
   		#if (Depth)
   			#if (Err < gShapeErr)
   				#declare smpTime[Slot][J][Pos] = S1;
					#declare smpSect[Slot][J][Pos] = F1;
					#declare smpNorm[Slot][J][Pos] = vcross(EvalQuadric(HTan[J],S1),
					                                        EvalCubic(VTan[J],S1));
					#declare smpU[Slot][J][Pos] = 
					         CalcChordAbscissa(sltSect, J+S1) / LenSect;
   				#declare Pos = Pos + 1;
   			#else
   				RecBuildData(S0, SMid, Depth-1)
   				RecBuildData(SMid, S1, Depth-1)
   			#end
   		#else
   			#if (Err > gMaxShapeErr) #declare gMaxShapeErr = Err; #end
   			#declare smpTime[Slot][J][Pos] = S1;
				#declare smpSect[Slot][J][Pos] = F1;
				#declare smpNorm[Slot][J][Pos] = vcross(EvalQuadric(HTan[J],S1),
				                                        EvalCubic(VTan[J],S1));
				#declare smpU[Slot][J][Pos] = 
				         CalcChordAbscissa(sltSect, J+S1) / LenSect;
   			#declare Pos = Pos + 1;
   		#end
   	#end
   	
   	#macro BuildDataVectors(T, Slot)
			#local Sect = splBuildSection(T)
			#local HTan = splDifferentiateSpline(Sect)
			#local tmpV1 = splBuildSection(T - gEpsilon)
			#local tmpV2 = splBuildSection(T + gEpsilon)
			#local VTan = splSubtractSplines(tmpV1, tmpV2)
         #local sltSect = sltOptimizeSpline(Sect)
			#local LenSect = CalcSplineLength(sltSect);

			// campionamento dei punti e delle normali: passo fisso
			#local J=0;
			#while (J<gNumShapeSegments)
				#declare smpTime[Slot][J][0] = 0;
				#declare smpSect[Slot][J][0] = EvalCubic(Sect[J],0);
				#declare smpNorm[Slot][J][0] = vcross(EvalQuadric(HTan[J],0),
				                                      EvalCubic(VTan[J],0));
				#declare smpU[Slot][J][0] = CalcChordAbscissa(sltSect, J) / LenSect;
				#local Pos = 1;
				#local I=0;
				#while (I < gShapeDiv)
					RecBuildData(I/gShapeDiv, (I+1)/gShapeDiv, gShapeDepth)
					#local I=I+1;
				#end
				#declare smpTime[Slot][J][Pos] = END_MARK;
				#local J=J+1;
			#end
   		#declare smpV[Slot] = CalcChordAbscissa(gsltPath, T) / gPathLength;
   	#end

		#ifdef(gsBufferName)
			#macro OutTriangle1()
				#write (fbfBufferStriscia, 
				        "smooth_triangle{",
				        nSect, ",",   nNorm, ",", vSect, ",", vNorm, ",",  
				        smpSect[PC][J][K[PC]-1], ",", smpNorm[PC][J][K[PC]-1],
					     "texture{gtxtWrapped matrix <",
					     MX1.x, ",", MX1.y, ",", MX1.z, ",", 
						  MY1.x, ",", MY1.y, ",", MY1.z, ",", 
						  MZ1.x, ",", MZ1.y, ",", MZ1.z, ",",
						  MO1.x, ",", MO1.y, ",", MO1.z, ">}}\n")
			#end
			#macro OutTriangle2()
				#write (fbfBufferStriscia, 
				        "smooth_triangle{",
				        nSect, ",", nNorm, ",", 
				        smpSect[PC][J][K[PC]-1], ",", smpNorm[PC][J][K[PC]-1], ",", 
				        smpSect[PC][J][K[PC]], ",", smpNorm[PC][J][K[PC]],
					     "texture{gtxtWrapped matrix <",
					     MX1.x, ",", MX1.y, ",", MX1.z, ",", 
						  MY1.x, ",", MY1.y, ",", MY1.z, ",", 
						  MZ1.x, ",", MZ1.y, ",", MZ1.z, ",",
						  MO1.x, ",", MO1.y, ",", MO1.z, ">}}\n")
			#end
		#else
			#macro OutTriangle1()
				smooth_triangle {
					vSect, vNorm, nSect, nNorm,
					smpSect[PC][J][K[PC]-1], smpNorm[PC][J][K[PC]-1] 
					texture { 
						gtxtWrapped
						matrix <MX1.x, MX1.y, MX1.z, 
						        MY1.x, MY1.y, MY1.z, 
						        MZ1.x, MZ1.y, MZ1.z,
						        MO1.x, MO1.y, MO1.z>
					}
				}
			#end
			#macro OutTriangle2()
				smooth_triangle { 
					nSect, nNorm, 
					smpSect[PC][J][K[PC]-1], smpNorm[PC][J][K[PC]-1],
					smpSect[PC][J][K[PC]], smpNorm[PC][J][K[PC]] 
					texture { 
						gtxtWrapped
						matrix <MX1.x, MX1.y, MX1.z, 
						        MY1.x, MY1.y, MY1.z, 
						        MZ1.x, MZ1.y, MZ1.z,
						        MO1.x, MO1.y, MO1.z>
					}
				}
			#end
		#end

		#macro DrawSection(T1, T2, UseBuffer)
			#local nPts = gNumShapeSegments * gShapeDiv + 1;
			#local Step = 1/(gShapeDiv);
		
			// calcolo dei dati della prima sezione
			#if (!UseBuffer)
				#local Size = gShapeDiv * pow(2,gShapeDepth+1) + 1;
				#declare smpTime = array[2][gNumShapeSegments][Size]
				#declare smpSect = array[2][gNumShapeSegments][Size]
				#declare smpNorm = array[2][gNumShapeSegments][Size]
				#declare smpU    = array[2][gNumShapeSegments][Size]
				#declare smpV    = array[2]
				
				#declare OldSlot = 0;
				#declare NewSlot = 1;
				BuildDataVectors(T1, OldSlot)
			#end
			
			// calcolo dei dati della seconda sezione
			BuildDataVectors(T2, NewSlot)
			
			// Disegno dei triangoli
			#local J=0;
			#local K = array[2]
			#while (J<gNumShapeSegments)
				#local K[0] = 1; #local K[1] = 1;
				#while(smpTime[0][J][K[0]] + smpTime[1][J][K[1]] < END_MARK)
					#if(smpTime[0][J][K[0]] <= smpTime[1][J][K[1]])
						#local PL = 1; #local PC = 0;
					#else
						#local PL = 0; #local PC = 1;
					#end
					#local D = smpTime[PL][J][K[PL]] - smpTime[PL][J][K[PL]-1];
					#local vSect = smpSect[PL][J][K[PL]-1];
					#local vNorm = smpNorm[PL][J][K[PL]-1];
					#local vU = smpU[PL][J][K[PL]-1];
					#while(smpTime[PC][J][K[PC]] <= smpTime[PL][J][K[PL]])
						#local A = (smpTime[PC][J][K[PC]] - smpTime[PL][J][K[PL]-1]) / D;
						#local nSect = smpSect[PL][J][K[PL]-1] + 
						               A*(smpSect[PL][J][K[PL]]-smpSect[PL][J][K[PL]-1]);
						#local nNorm = smpNorm[PL][J][K[PL]-1] + 
						               A*(smpNorm[PL][J][K[PL]]-smpNorm[PL][J][K[PL]-1]);
						#local nU    = smpU[PL][J][K[PL]-1] + 
						               A*(smpU[PL][J][K[PL]]-smpU[PL][J][K[PL]-1]);

						#local DU1 = nU - vU;
						#local DU2 = smpU[PC][J][K[PC]-1] - vU; 
						#local DV2 = smpV[PC] - smpV[PL];
						#local Det = DU1 * DV2;
						#if (Det)
							#local MX = nSect - vSect;
							#local MY = smpSect[PC][J][K[PC]-1] - vSect;
							#local MX1 = DV2*MX / Det;
							#local MY1 = (DU1*MY - DU2*MX) / Det;
							#local MZ1 = vcross(MX1, MY1);
							#local MO1 = vSect - vU*MX1 - smpV[PL]*MY1;
							OutTriangle1()
							/*smooth_triangle {
								vSect, vNorm, nSect, nNorm,
								smpSect[PC][J][K[PC]-1], smpNorm[PC][J][K[PC]-1] 
								texture { 
									gtxtWrapped
									matrix <MX1.x, MX1.y, MX1.z, 
									        MY1.x, MY1.y, MY1.z, 
									        MZ1.x, MZ1.y, MZ1.z,
									        MO1.x, MO1.y, MO1.z>
								}
							}*/
						#end
							
						#local DU1 = smpU[PC][J][K[PC]] - smpU[PC][J][K[PC]-1];
						#local DU2 = smpU[PC][J][K[PC]] - nU; 
						#local Det = DU1 * DV2;
						#if (Det)
							#local MX = smpSect[PC][J][K[PC]] - smpSect[PC][J][K[PC]-1];
							#local MY = smpSect[PC][J][K[PC]] - nSect;
							#local MX1 = DV2*MX / Det;
							#local MY1 = (DU1*MY - DU2*MX) / Det;
							#local MZ1 = vcross(MX1, MY1);
							#local MO1 = nSect - MX - (nU-DU1)*MX1 - smpV[PL]*MY1;
		               OutTriangle2()
							/*smooth_triangle { 
								nSect, nNorm, 
								smpSect[PC][J][K[PC]-1], smpNorm[PC][J][K[PC]-1],
								smpSect[PC][J][K[PC]], smpNorm[PC][J][K[PC]] 
								texture { 
									gtxtWrapped
									matrix <MX1.x, MX1.y, MX1.z, 
									        MY1.x, MY1.y, MY1.z, 
									        MZ1.x, MZ1.y, MZ1.z,
									        MO1.x, MO1.y, MO1.z>
								}
							}*/
						#end

						#local vSect = nSect; #local vNorm = nNorm; #local vU = nU;
						#local K[PC] = K[PC] + 1;
					#end
					#local K[PL] = K[PL] + 1;
				#end
				#local J=J+1;
			#end
			
			// Riciclaggio dei dati
			#local Temp = OldSlot;
			#declare OldSlot = NewSlot;
			#declare NewSlot = Temp;
		#end

/****************************************************************************
**              Disegno dei triangoli col texture mapping.                 **
**                         versione non adattiva                           **
****************************************************************************/
	#else
   	#macro BuildDataVectors(T, Slot)
			#local Sect = splBuildSection(T)
			#local HTan = splDifferentiateSpline(Sect)
			#local tmpV1 = splBuildSection(T - gEpsilon)
			#local tmpV2 = splBuildSection(T + gEpsilon)
			#local VTan = splSubtractSplines(tmpV1, tmpV2)
         #local sltSect = sltOptimizeSpline(Sect)
			#local LenSect = CalcSplineLength(sltSect);
         
			// campionamento dei punti e delle normali
			#local J=0;
			#while (J<gNumShapeSegments)
				#local I=0;
				#while (I <= gShapeDiv)
					#declare smpSect[Slot][J][I] = EvalCubic(Sect[J],I*Step);
					#declare smpNorm[Slot][J][I] = vcross((EvalQuadric(HTan[J],I*Step)),
					                                      (EvalCubic(VTan[J],I*Step)));
					#declare smpU[Slot][J][I] = 
					         CalcChordAbscissa(sltSect, J + I/gShapeDiv) / LenSect;
					#local I=I+1;
				#end
				#local J=J+1;
			#end
			#declare smpV[Slot] = CalcChordAbscissa(gsltPath, T)/gPathLength;
   	#end

		#ifdef(gsBufferName)
			#macro OutTriangle1()
				#write (fbfBufferStriscia, 
				        "smooth_triangle{",
					     smpSect[0][J][I], ",", smpNorm[0][J][I], ",",
					     smpSect[0][J][I+1], ",", smpNorm[0][J][I+1], ",",
					     smpSect[1][J][I], ",", smpNorm[1][J][I] 
					     "texture{gtxtWrapped matrix <",
					     MX1.x, ",", MX1.y, ",", MX1.z, ",", 
						  MY1.x, ",", MY1.y, ",", MY1.z, ",", 
						  MZ1.x, ",", MZ1.y, ",", MZ1.z, ",",
						  MO1.x, ",", MO1.y, ",", MO1.z, ">}}\n")
			#end
			#macro OutTriangle2()
				#write (fbfBufferStriscia, 
				        "smooth_triangle{",
					     smpSect[0][J][I+1], ",", smpNorm[0][J][I+1], ",", 
					     smpSect[1][J][I], ",", smpNorm[1][J][I], ",",
					     smpSect[1][J][I+1], ",", smpNorm[1][J][I+1] 
					     "texture{gtxtWrapped matrix <",
					     MX1.x, ",", MX1.y, ",", MX1.z, ",", 
						  MY1.x, ",", MY1.y, ",", MY1.z, ",", 
						  MZ1.x, ",", MZ1.y, ",", MZ1.z, ",",
						  MO1.x, ",", MO1.y, ",", MO1.z, ">}}\n")
			#end
		#else
			#macro OutTriangle1()
				smooth_triangle {
					smpSect[0][J][I],   smpNorm[0][J][I], 
					smpSect[0][J][I+1], smpNorm[0][J][I+1],
					smpSect[1][J][I],   smpNorm[1][J][I] 
					texture { 
						gtxtWrapped
						matrix <MX1.x, MX1.y, MX1.z, 
						        MY1.x, MY1.y, MY1.z, 
						        MZ1.x, MZ1.y, MZ1.z,
						        MO1.x, MO1.y, MO1.z>
					}
				}
			#end
			#macro OutTriangle2()
				smooth_triangle { 
					smpSect[0][J][I+1], smpNorm[0][J][I+1], 
					smpSect[1][J][I],   smpNorm[1][J][I],
					smpSect[1][J][I+1], smpNorm[1][J][I+1] 
					texture { 
						gtxtWrapped
						matrix <MX1.x, MX1.y, MX1.z, 
						        MY1.x, MY1.y, MY1.z, 
						        MZ1.x, MZ1.y, MZ1.z,
						        MO1.x, MO1.y, MO1.z>
					}
				}
			#end
		#end
		
		#macro DrawSection(T1, T2, UseBuffer)
			#local nPts = gNumShapeSegments * gShapeDiv + 1;
			#local Step = 1/(gShapeDiv);
		
			// calcolo dei dati della prima sezione
			#if (!UseBuffer)
				#declare smpSect = array[2][gNumShapeSegments][gShapeDiv+1]
				#declare smpNorm = array[2][gNumShapeSegments][gShapeDiv+1]
				#declare smpU    = array[2][gNumShapeSegments][gShapeDiv+1]
				#declare smpV    = array[2]
				
				#declare OldSlot = 0;
				#declare NewSlot = 1;
				BuildDataVectors(T1, OldSlot)
			#end
			
			// calcolo dei dati della seconda sezione
			BuildDataVectors(T2, NewSlot)
			
			// Disegno dei triangoli
			#local DV2=smpV[1]-smpV[0];
			#local J=0;
			#while (J<gNumShapeSegments)
				#local I=0;
				#while (I<gShapeDiv)
					#local DU1=smpU[0][J][I+1]-smpU[0][J][I];
					#local DU2=smpU[1][J][I]-smpU[0][J][I]; 
					#local Det = DU1*DV2;
					#if (Det)
						#local MX = smpSect[0][J][I+1] - smpSect[0][J][I];
						#local MY = smpSect[1][J][I] - smpSect[0][J][I];
						#local MX1 = DV2*MX / Det;
						#local MY1 = (DU1*MY - DU2*MX) / Det;
						#local MZ1 = vcross(MX1, MY1);
						#local MO1 = smpSect[0][J][I] - smpU[0][J][I]*MX1 - smpV[0]*MY1;
						OutTriangle1()
					#end
						
					#local DU1=smpU[1][J][I+1]-smpU[1][J][I];
					#local DU2=smpU[1][J][I+1]-smpU[0][J][I+1]; 
					#local Det = DU1*DV2;
					#if (Det)
						#local MX = smpSect[1][J][I+1] - smpSect[1][J][I];
						#local MY = smpSect[1][J][I+1] - smpSect[0][J][I+1];
						#local MX1 = DV2*MX / Det;
						#local MY1 = (DU1*MY - DU2*MX) / Det;
						#local MZ1 = vcross(MX1, MY1);
						#local MO1 = smpSect[0][J][I+1] - MX - 
						             (smpU[0][J][I+1]-DU1)*MX1 - smpV[0]*MY1;
						OutTriangle2()
					#end
					#local I=I+1;
				#end
				#local J=J+1;
			#end
			
			// Riciclaggio dei dati
			#local Temp = OldSlot;
			#declare OldSlot = NewSlot;
			#declare NewSlot = Temp;
		#end
	#end

/****************************************************************************
**             Disegno dei triangoli senza texture mapping.                **
**                           versione adattiva                             **
****************************************************************************/
#else
   #if (gShapeDepth)
   	// campionamento dei punti e delle normali: passo induttivo
   	#declare END_MARK = 1e+8;
   	#macro RecBuildData(S0, S1, Depth)
			#local SMid = (S0+S1)/2;
			#local F1 = EvalCubic(Sect[J],S1); 
			#local Err = vlength(EvalCubic(Sect[J],SMid) - (smpSect[Slot][J][Pos-1]+F1)/2);
   		#if (Depth)
   			#if (Err < gShapeErr)
   				#declare smpTime[Slot][J][Pos] = S1;
					#declare smpSect[Slot][J][Pos] = F1;
					#declare smpNorm[Slot][J][Pos] = vcross(EvalQuadric(HTan[J],S1),
					                                        EvalCubic(VTan[J],S1));
   				#declare Pos = Pos + 1;
   			#else
   				RecBuildData(S0, SMid, Depth-1)
   				RecBuildData(SMid, S1, Depth-1)
   			#end
   		#else
   			#if (Err > gMaxShapeErr) #declare gMaxShapeErr = Err; #end
   			#declare smpTime[Slot][J][Pos] = S1;
				#declare smpSect[Slot][J][Pos] = F1;
				#declare smpNorm[Slot][J][Pos] = vcross(EvalQuadric(HTan[J],S1),
				                                        EvalCubic(VTan[J],S1));
   			#declare Pos = Pos + 1;
   		#end
   	#end
   	
   	#macro BuildDataVectors(T, Slot)
			#local Sect = splBuildSection(T)
			#local HTan = splDifferentiateSpline(Sect)
			#local tmpV1 = splBuildSection(T - gEpsilon)
			#local tmpV2 = splBuildSection(T + gEpsilon)
			#local VTan = splSubtractSplines(tmpV1, tmpV2)

			// campionamento dei punti e delle normali: passo fisso
			#local J=0;
			#while (J<gNumShapeSegments)
				#declare smpTime[Slot][J][0] = 0;
				#declare smpSect[Slot][J][0] = EvalCubic(Sect[J],0);
				#declare smpNorm[Slot][J][0] = vcross(EvalQuadric(HTan[J],0),
				                                      EvalCubic(VTan[J],0));
				#local Pos = 1;
				#local I=0;
				#while (I < gShapeDiv)
					RecBuildData(I/gShapeDiv, (I+1)/gShapeDiv, gShapeDepth)
					#local I=I+1;
				#end
				#declare smpTime[Slot][J][Pos] = END_MARK;
				#local J=J+1;
			#end
   	#end

		#ifdef(gsBufferName)
			#macro OutTriangles()
				#write (fbfBufferStriscia, 
				        "smooth_triangle{", 
				        nSect, ",",   nNorm, ",", vSect, ",", vNorm, ",",  
				        smpSect[PC][J][K[PC]-1], ",", smpNorm[PC][J][K[PC]-1],
				        "}\nsmooth_triangle{",
				        nSect, ",", nNorm, ",", 
				        smpSect[PC][J][K[PC]-1], ",", smpNorm[PC][J][K[PC]-1], ",", 
				        smpSect[PC][J][K[PC]], ",", smpNorm[PC][J][K[PC]],"}\n")
			#end
		#else
			#macro OutTriangles()
				smooth_triangle { 
					vSect, vNorm, nSect, nNorm,
					smpSect[PC][J][K[PC]-1], smpNorm[PC][J][K[PC]-1]
				}
				smooth_triangle { 
					nSect, nNorm, 
					smpSect[PC][J][K[PC]-1], smpNorm[PC][J][K[PC]-1], 
					smpSect[PC][J][K[PC]], smpNorm[PC][J][K[PC]]
				}
			#end
		#end
   	
		#macro DrawSection(T1, T2, UseBuffer)
			#local nPts = gNumShapeSegments * gShapeDiv + 1;
			#local Step = 1/(gShapeDiv);
		
			// calcolo dei dati della prima sezione
			#if (!UseBuffer)
				#local Size = gShapeDiv * pow(2,gShapeDepth+1) + 1;
				#declare smpTime = array[2][gNumShapeSegments][Size]
				#declare smpSect = array[2][gNumShapeSegments][Size]
				#declare smpNorm = array[2][gNumShapeSegments][Size]
				#declare OldSlot = 0;
				#declare NewSlot = 1;
				BuildDataVectors(T1, OldSlot)
			#end
			
			// calcolo dei dati della seconda sezione
			BuildDataVectors(T2, NewSlot)
			
			// Disegno dei triangoli
			#local J=0;
			#local K = array[2]
			#while (J<gNumShapeSegments)
				#local K[0] = 1; #local K[1] = 1;
				#while(smpTime[0][J][K[0]] + smpTime[1][J][K[1]] < END_MARK)
					#if(smpTime[0][J][K[0]] <= smpTime[1][J][K[1]])
						#local PL = 1; #local PC = 0;
					#else
						#local PL = 0; #local PC = 1;
					#end
					#local D = smpTime[PL][J][K[PL]] - smpTime[PL][J][K[PL]-1];
					#local vSect = smpSect[PL][J][K[PL]-1];
					#local vNorm = smpNorm[PL][J][K[PL]-1];
					#while(smpTime[PC][J][K[PC]] <= smpTime[PL][J][K[PL]])
						#local A = (smpTime[PC][J][K[PC]] - smpTime[PL][J][K[PL]-1]) / D;
						#local nSect = smpSect[PL][J][K[PL]-1] + 
						               A*(smpSect[PL][J][K[PL]]-smpSect[PL][J][K[PL]-1]);
						#local nNorm = smpNorm[PL][J][K[PL]-1] + 
						               A*(smpNorm[PL][J][K[PL]]-smpNorm[PL][J][K[PL]-1]);
						OutTriangles()
						#local vSect = nSect; #local vNorm = nNorm;
						#local K[PC] = K[PC] + 1;
					#end
					#local K[PL] = K[PL] + 1;
				#end
				#local J=J+1;
			#end
			
			// Riciclaggio dei dati
			#local Temp = OldSlot;
			#declare OldSlot = NewSlot;
			#declare NewSlot = Temp;
		#end

/****************************************************************************
**             Disegno dei triangoli senza texture mapping.                **
**                         versione non adattiva                           **
****************************************************************************/
   #else
   	#macro BuildDataVectors(T, Slot)
   		// Costruzione delle spline di controllo
			#local Sect = splBuildSection(T)
			#local HTan = splDifferentiateSpline(Sect)
			#local tmpV1 = splBuildSection(T - gEpsilon)
			#local tmpV2 = splBuildSection(T + gEpsilon)
			#local VTan = splSubtractSplines(tmpV1, tmpV2)

			// campionamento dei punti e delle normali
			#local J=0;
			#while (J<gNumShapeSegments)
				#local I=0;
				#while (I <= gShapeDiv)
					#declare smpSect[Slot][J][I] = EvalCubic(Sect[J],I*Step);
					#declare smpNorm[Slot][J][I] = vcross((EvalQuadric(HTan[J],I*Step)),
					                                      (EvalCubic(VTan[J],I*Step)));
					#local I=I+1;
				#end
				#local J=J+1;
			#end
   	#end

		#ifdef(gsBufferName)
			#macro OutTriangles()
				#write (fbfBufferStriscia, 
				        "smooth_triangle{", 
				        smpSect[0][J][I], ",",   smpNorm[0][J][I], ",", 
				        smpSect[1][J][I], ",",   smpNorm[1][J][I], ",", 
				        smpSect[0][J][I+1], ",", smpNorm[0][J][I+1], 
				        "}\nsmooth_triangle{",
				        smpSect[1][J][I+1], ",", smpNorm[1][J][I+1], ",", 
				        smpSect[1][J][I], ",",   smpNorm[1][J][I], ",", 
				        smpSect[0][J][I+1], ",", smpNorm[0][J][I+1],"}\n")
			#end
		#else
			#macro OutTriangles()
				smooth_triangle { smpSect[0][J][I],   smpNorm[0][J][I], 
				                  smpSect[1][J][I],   smpNorm[1][J][I], 
				                  smpSect[0][J][I+1], smpNorm[0][J][I+1] }
				smooth_triangle { smpSect[1][J][I+1], smpNorm[1][J][I+1], 
				                  smpSect[1][J][I],   smpNorm[1][J][I],
				                  smpSect[0][J][I+1], smpNorm[0][J][I+1] }
			#end
		#end
		
		#macro DrawSection(T1, T2, UseBuffer)
			#local nPts = gNumShapeSegments * gShapeDiv + 1;
			#local Step = 1/(gShapeDiv);
		
			// calcolo dei dati della prima sezione
			#if (!UseBuffer)
				#declare smpSect = array[2][gNumShapeSegments][gShapeDiv+1]
				#declare smpNorm = array[2][gNumShapeSegments][gShapeDiv+1]
				#declare OldSlot = 0;
				#declare NewSlot = 1;
				BuildDataVectors(T1, OldSlot)
			#end
			
			// calcolo dei dati della seconda sezione
			BuildDataVectors(T2, NewSlot)
			
			// Disegno dei triangoli
			#local J=0;
			#while (J<gNumShapeSegments)
				#local I=0;
				#while (I<gShapeDiv)
					OutTriangles()
					/* // Fa ZigZag :)
					smooth_triangle { smpSect[0][J][I], smpNorm[0][J][I], 
					           smpSect[0][J][I] + (smpSect[1][J][I] - smpSect[0][J][I])*.9, smpNorm[1][J][I],
					           smpSect[0][J][I] + (smpSect[0][J][I+1] - smpSect[0][J][I])*.9, smpNorm[0][J][I+1] }
					smooth_triangle { smpSect[1][J][I+1], smpNorm[1][J][I+1]
					           smpSect[1][J][I+1] + (smpSect[1][J][I] - smpSect[1][J][I+1])*.9, smpNorm[1][J][I],
					           smpSect[1][J][I+1] + (smpSect[0][J][I+1] - smpSect[1][J][I+1])*.9, smpNorm[0][J][I+1] }
					*/
					#local I=I+1;
				#end
				#local J=J+1;
			#end
			
			// Riciclaggio dei dati
			#local Temp = OldSlot;
			#declare OldSlot = NewSlot;
			#declare NewSlot = Temp;
		#end
	#end
#end
