//////////
//
//	File:		ComApplication.h
//
//	Contains:	Application-specific code for scripting application.
//
//	Written by:	Tim Monroe
//
//	Copyright:	 1994-1997 by Apple Computer, Inc., all rights reserved.
//
//	Change History (most recent first):
//
//	   <5>	 	09/24/97	rtm		upgraded to latest QuickTime VR headers
//	   <4>	 	09/11/97	rtm		merged MacApplication.h and WinApplication.h
//	   <3>	 	08/21/97	rtm		begun adding Windows support
//	   <2>	 	11/27/96	rtm		conversion to personal coding style
//	   <1>	 	12/21/94	khs		first file
//	   
//////////

#pragma once

//////////
// header files
//////////

#ifndef __QUICKTIMEVR__
#include <QuickTimeVR.h>
#endif

#ifndef __QTUtilities__
#include "QTUtilities.h"
#endif

#ifndef __QTVRUtilities__
#include "QTVRUtilities.h"
#endif

#include <MediaHandlers.h>
#include <Movies.h>
#include <Resources.h>
#include <Sound.h>
#include <SoundComponents.h>
#include <SoundSprocket.h>
#include <TextUtils.h>

#include <string.h>
#include <stdlib.h>

#if TARGET_OS_MAC
#include <AppleEvents.h>
#include "MacFramework.h"
#include "AppConfiguration.h"
#endif

#if TARGET_OS_WIN32
#include "WinFramework.h"
#endif

#include "ComResource.h"
#include "VRMovies.h"
#include "VR3DObjects.h"
#include "VRSound.h"
#include "VREffects.h"

//////////
// constants
//////////

#define kQTMaxSoundVolume		256

enum {
	kScriptFileType				= FOUR_CHAR_CODE('TEXT'),
	kScriptFileCreator			= FOUR_CHAR_CODE('VRsc')
};

enum eAppMenus {
	mTesting = 131
};

enum eTestingMenu {
	iTest1 = 1,
	iTest2,
	iTest3,
	iTest4
};

enum {
	iTest1Item = MENU_IDENTIFIER(mTesting, iTest1),
	iTest2Item,
	iTest3Item,
	iTest4Item
};


//////////
// structures
//////////

// application-specific data;
// this data applies to a specific VR movie/window combination
typedef struct ApplicationDataRecord {

	// *** QTVR callback procedures ***
	QTVRBackBufferImagingUPP	fBackBufferProc;	// a routine descriptor for our back buffer routine
	QTVRImagingCompleteUPP		fPrescreenProc;		// a routine descriptor for our prescreen routine
	
	// *** General data ***
	Boolean						fViewHasChanged;	// has the (pan, tilt, or FOV of the) view changed?
	Boolean						fSoundHasChanged;	// has some sound changed?
	
	// *** SoundSprocket data ***
	SSpListenerReference		fListener;			// the single listener
	
	// *** 3D object data ***
	TQ3ViewObject				fView;				// the view for the scene
	GWorldPtr					fQD3DDCGWorld;		// the offscreen graphics world used for the pixmap draw context
	Boolean						fQD3DFOVIsVert;		// is the QD3D camera FOV vertical?
	RGBColor					fQD3DKeyColor;		// the color for chroma key compositing for QD3D textures (this is also the background color for the QD3D draw context)

	// *** QuickTime video effects data ***
	GWorldPtr					fSourceGWorld;		// the offscreen graphics world for the source node picture
	GWorldPtr					fTargetGWorld;		// the offscreen graphics world for the target node picture
	ImageDescriptionHandle		fSourceGWDesc;		// the image description of the source offscreen graphics world
	ImageDescriptionHandle		fTargetGWDesc;		// the image description of the target offscreen graphics world
	VRScriptTransitionPtr		fActiveTransition;	// pointer to the list entry of the active node transition effect

	// *** Array of our linked list head pointers ***
	struct VRScriptGeneric		*fListArray[kVRScript_FinalEntryType + 1];
	
} ApplicationDataRecord, *ApplicationDataPtr, **ApplicationDataHdl;


//////////
// function prototypes
//////////

#if TARGET_OS_MAC
void					InstallAppleEventHandlers (void);
PASCAL_RTN OSErr		HandleOpenApplicationAppleEvent (const AppleEvent *theMessage, const AppleEvent *theReply, long theRefcon);			
PASCAL_RTN OSErr		HandleOpenDocumentAppleEvent (const AppleEvent *theMessage, const AppleEvent *theReply, long theRefcon);
PASCAL_RTN OSErr		HandlePrintDocumentAppleEvent (const AppleEvent *theMessage, const AppleEvent *theReply, long theRefcon);
PASCAL_RTN OSErr		HandleQuitApplicationAppleEvent (const AppleEvent *theMessage, const AppleEvent *theReply, long theRefcon);
#endif	// TARGET_OS_MAC

// the other function prototypes are in the file MacFramework.h or WinFramework.h