

camera { location  <0, 30, 120> look_at <0, 40, 0>}

sky_sphere { pigment {rgb <.4,.5,.9>}}

light_source {<100,200,100> colour rgb 1.7}

plane {y,0 pigment {rgb <.3,.7,.3>}}

//---------------------------------   

   
// include the body parts
#include "golf_swing_parts.inc"


// in this case the golf club prop needs a completely different shape
// so this declareation overrules the one that was created automatically
#declare golfclub = union {
	cylinder {0,-50*y,0.3}         
	box {<-0.1,-50,-0.1> <0.1,-49,3>}
}	
// And while we're at it, let's make the head bigger
#declare head = cylinder {0,<0,3.71,0>,1 scale <3,2,3>}
#declare head = sphere {0,1 scale <3,4,3> translate y*3.71/2}


// include the body structure and movement
#include "golf_swing.inc"


// invove each of the ROOT level objects
// figures are often defined from the hip 
object {HIPS pigment {rgb 1}}

object {GOLFCLUB pigment {rgb 1}}


