# Given FOO.BVH  a motion capture file
#
# Determine the heirarchy structure
# Output: 
#   1. FOO.INC	  The main POV bit
#   2. FOO.DAT    The motion data
#   3. FOO_PARTS.INC  Default body parts

############################
# Open files

print "BVH Filename: ";
$file = <STDIN>;
chomp $file;
$file = lc $file;
if ($file =~ /\.bvh/) {
  $file =~ s/\.bvh//;
}

$parts = $file."_parts.inc";

open(BVH,"$file.bvh") or die "Can't open $file.bvh $!\n";
open(INC,">$file.inc") or die "Can't create $file.inc $!\n";
open(TXT,">$file.dat") or die "Can't create $file.dat $!\n";
open(PARTS,">$parts") or die "Can't create $parts $!\n";

############################
# Preprocessing
#   find out how many channels and frames there are

$chan = 0;

while ($line = <BVH>) {
  chomp $line;
  $line = lc $line;
  if ($line =~ /^\s*channels\s/) {
    $line =~ s/^\s*//;
    ($l,$c) = split /\s/,$line;
    $chan += $c;
  }
  elsif ($line =~ /^\s*frames:\s/) {
    $line =~ s/^\s*//;
    ($l,$frames) = split /\s\s*/,$line;
  }
}

$frames--;
print "\nfinal_frame = $frames\n";

close(BVH);

###########################
# Heading

print INC "//================================\n";
print INC "// $file.inc created by bvh2pov\n";
print INC "//\n";
print INC "// final_frame = $frames\n\n\n";
print INC "//file handling\n";
print INC "#fopen IN \"$file.dat\" read\n\n";
print INC "#declare N=-1;\n";
print INC "#while (N<frame_number)\n";
print INC "  #read(IN\n";

$i=0;
while ($i < $chan) {
  $i++;
  print INC "    ,V$i\n";
}
print INC "    )\n";

print INC "  #declare N=N+1;\n";
print INC "#end\n\n";

print INC "//  Body declarations\n\n";

############################
# Main Processing

open(BVH,"$file.bvh") or die "Can't re-open $file.bvh $!\n";

$depth = 0;
$thischan = 0;

while ($line = <BVH>) {
  chomp $line;
  $l = lc $line;
  $l =~ s/^\s*//;			#remove leading whitespace
  ($verb,$nouns) = split /\s/,$l,2;	#determine command

## HIERARCHY
  if ($verb eq "hierarchy") {
     # do nothing
  }

## ROOT
  elsif ($verb eq "root") {
    $joint[$depth] = $nouns;
    $name = uc $nouns;
    print "Top level object: $name\n";
  }

## OPEN BRACE
  elsif ($verb eq "{") {
    $depth++;
  }

## CLOSE BRACE
  elsif ($verb eq "}") {
    $depth--;
    if ($depth >= 0) {
      $i=$depth;
      $name = uc $joint[$i];
      $out  = "#declare $name = union {\n";
      $out .= "   object {$joint[$i]}\n";
      $out .= $object[$i];
      if ($depth == 0) {$out .= $roottran;}
      $out .= "}\n";
      if ($name ne "") {
        print INC $out;
      }
    }
    if ($depth == 0) { #force root object even if no child objects exist
      $part = "#declare ". lc $name ." = sphere {0,1}\n";
      print PARTS $part;
    }
    $object[$i] = "";
    $joint[$i] = "";    
  }

## OFFSET
  elsif ($verb eq "offset") {
    ($x,$y,$z) = split /\t/,$nouns;
    $x = $x*1; # convert from "1.23000000" format to "1.23"
    $y = $y*1;
    $z = $z*1;
    $j = $depth-2;
    if ($j >= 0) {
      if ($j > 0) {
        $part = "#declare $joint[$j] = cylinder {0,<$x,$y,$z>,1.0}\n";
      }
      $found{$joint[$j]}++;
      if ($found{$joint[$j]} == 1) {print PARTS $part;}
      $i=$depth-1;
      $name = uc $joint[$i];
      if ($name ne "") {
        $object1 = "   object {$name";
        $object3 = " translate <$x,$y,$z>}\n";
      }
    }
  }

## CHANNELS
  elsif ($verb eq "channels") {
    ($c,$stuff) = split /\s+/,$nouns,2;
    $i = 0;
    $trans = " ";
    while ($i < $c) {
      $thischan++;
      ($a,$stuff) = split /\s+/,$stuff,2;
      if ($a eq "xposition") {$trans .= " translate x*V$thischan";}
      if ($a eq "yposition") {$trans .= " translate y*V$thischan";}
      if ($a eq "zposition") {$trans .= " translate z*V$thischan ";}
      if ($a eq "xrotation") {$trans = " rotate x*V$thischan" . $trans;}
      if ($a eq "yrotation") {$trans = " rotate y*V$thischan" . $trans;}
      if ($a eq "zrotation") {$trans = " rotate z*V$thischan" . $trans;}
      $i++;
    }
    if ($depth > 1) {
      $object[$depth-2] .= $object1.$trans.$object3;
    }
    if ($depth == 1) {
      $roottran = "  ".$trans."\n";
    }
  }

## JOINT
  elsif ($verb eq "joint") {
    $joint[$depth] = $nouns;     
  }

## END SITE
  elsif ($verb eq "end") {
     # do nothing
  }

## MOTION
  elsif ($verb eq "motion") {
     # do nothing
  }

## FRAMES
  elsif ($verb eq "frames:") {
    $final_frame = $nouns-1;
  }

## FRAME TIME
  elsif ($verb eq "frame") {
    # switch to outputting the TXT file
    while ($line = <BVH>) {
      $line =~ s/\t/,/g;		# replace tabs by commas 
      print TXT $line;
    }
  }

## Anything else
  else {
    print "*** unexpected command : >>$verb<<\n   $line\n";
    <STDIN>;
  }
}

print "\nFinished: [press return]\n";
<STDIN>;
exit;
