//#version unofficial MegaPOV 0.7;
#include "colors.inc"
#include "textures.inc"


#ifndef(Color_Scheme)
#declare Color_Scheme = 1;
#end
#switch(Color_Scheme)
#case(1)
background{Gray60}
#declare Grid_Color = Gray30;
#break
#case(2)
background{Black}
#declare Grid_Color=Green;
#break
#case(3)
background{SkyBlue}
#declare Grid_Color=White;
#end

//Grid Construction
#declare Grid_Line = 
cylinder {<0,-100,0>,<0,100,0>,.02
pigment {Grid_Color}
finish {Luminous}
no_shadow 
translate x*-50}
#ifndef(Grid_Spacing)
#declare Grid_Spacing =1;
#end
#declare Vert_Grid = union {
#declare Count = 0;
#while(Count<101)
object {Grid_Line 
translate x*Count}
#declare Count = Count+Grid_Spacing;
#end}
#declare Horiz_Grid = 
object {Vert_Grid rotate z*90}
#declare Front_Grid = union {
object {Vert_Grid}
object {Horiz_Grid}}
#declare Top_Grid = 
object {Front_Grid rotate x*90}
#declare Side_Grid = 
object {Front_Grid rotate y*90}

//View Definitions: 1(Front) 2(Top) 3(Side) 4(Camera)
#ifndef(View)
#declare View = 1;
#end
#ifndef(Zoom_Factor)
#declare Zoom_Factor = 10;
#end
#ifndef(Zoom_Amount)
#declare Zoom_Amount = 1;
#end
#ifndef(Camera)
#declare Camera = <-5,5,-10>;
#end
#ifndef(Target)
#declare Target = <0,0,0>;
#end
#ifndef(Angle)
#declare Angle = 20;
#end
#ifndef(Camera_Proxy)
#declare Camera_Proxy=on;
#end
#ifndef(Pan_X)
#declare Pan_X=0;
#end
#ifndef(Pan_Y)
#declare Pan_Y=0;
#end
#ifndef(Pan_Z)
#declare Pan_Z=0;
#end
#ifndef(Grid)
#declare Grid = on;
#end
#ifndef(Axes)
#declare Axes = on;
#end
#ifndef(Light_Proxy)
#declare Light_Proxy = on;
#end

//Create Views
#switch(View)
#case(1)//Front
camera{location <Pan_X,Pan_Y,-Zoom_Factor*Zoom_Amount>
look_at <Pan_X,Pan_Y,0>
orthographic}
#if(Grid=on)
object {Front_Grid}
#end
text {
ttf "arial.ttf"
"FRONT"
.1,0
//align_center
pigment {Green}
finish {Luminous}
no_shadow
translate <0,Zoom_Factor/3,0>}
#break
#case(2)//Top
camera {location<Pan_X,Zoom_Factor*Zoom_Amount,Pan_Z>
look_at<0,0,0>
orthographic}
#if(Grid=on)
object {Top_Grid}
#end
text {
ttf "arial.ttf"
"TOP"
.1,0
//align_center
pigment {Green}
finish {Luminous}
no_shadow
rotate x*90
translate <0,0,Zoom_Factor/3>}
#break
#case(3)//Side
camera {location<Zoom_Factor*Zoom_Amount,Pan_Y,Pan_Z>
look_at<0,Pan_Y,Pan_Z>
orthographic}
#if(Grid=on)
object {Side_Grid}
#end
text {
ttf "arial.ttf"
"SIDE"
.1,0
//align_center
pigment {Green}
finish {Luminous}
no_shadow
rotate y*-90
translate <0,Zoom_Factor/3,0>}
#break
#case(4)//Perspective
camera {location Camera
look_at Target}
#break  
#case(5)//Render
camera {location Camera
look_at Target}
#break  
Case(6)
camera {
location <0,0,-50>
look_at <0,0,0>}
#end

//Camera Proxy
#if(Camera_Proxy=on)
#if(View<4)
union {
cylinder{Camera,Target,.03}
sphere{Camera,.05}
sphere {Target,.05}
pigment {Brown}
finish {Luminous}
no_shadow}
#end
#end
//Create Axis Marker
#if(View<5)
#if(Axes = on)
union {
union {
cylinder {<0,0,0>,<3,0,0>,.05}
cone {<3,0,0>,.1,<3.25,0,0>,0}
pigment {Red}
finish {Luminous}
no_shadow}
union {
cylinder {<0,0,0>,<0,3,0>,.05}
cone {<0,3,0>,.1,<0,3.25,0>,0}
pigment {Green}
finish {Luminous}
no_shadow}
union {
cylinder {<0,0,0>,<0,0,3>,.05}
cone {<0,0,3>,.1,<0,0,3.25>,0}
pigment {Blue}
finish {Luminous}
no_shadow}}
#end
#end

